/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBatchPredictionRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, UpdateBatchPredictionRequest> {
    private static final SdkField<String> BATCH_PREDICTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BatchPredictionId").getter(UpdateBatchPredictionRequest.getter(UpdateBatchPredictionRequest::batchPredictionId)).setter(UpdateBatchPredictionRequest.setter(Builder::batchPredictionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchPredictionId").build()}).build();
    private static final SdkField<String> BATCH_PREDICTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BatchPredictionName").getter(UpdateBatchPredictionRequest.getter(UpdateBatchPredictionRequest::batchPredictionName)).setter(UpdateBatchPredictionRequest.setter(Builder::batchPredictionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchPredictionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_PREDICTION_ID_FIELD, BATCH_PREDICTION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BatchPredictionId", BATCH_PREDICTION_ID_FIELD);
            this.put("BatchPredictionName", BATCH_PREDICTION_NAME_FIELD);
        }
    });
    private final String batchPredictionId;
    private final String batchPredictionName;

    private UpdateBatchPredictionRequest(BuilderImpl builder) {
        super(builder);
        this.batchPredictionId = builder.batchPredictionId;
        this.batchPredictionName = builder.batchPredictionName;
    }

    public final String batchPredictionId() {
        return this.batchPredictionId;
    }

    public final String batchPredictionName() {
        return this.batchPredictionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.batchPredictionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchPredictionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBatchPredictionRequest)) {
            return false;
        }
        UpdateBatchPredictionRequest other = (UpdateBatchPredictionRequest)((Object)obj);
        return Objects.equals(this.batchPredictionId(), other.batchPredictionId()) && Objects.equals(this.batchPredictionName(), other.batchPredictionName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBatchPredictionRequest").add("BatchPredictionId", (Object)this.batchPredictionId()).add("BatchPredictionName", (Object)this.batchPredictionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BatchPredictionId": {
                return Optional.ofNullable(clazz.cast(this.batchPredictionId()));
            }
            case "BatchPredictionName": {
                return Optional.ofNullable(clazz.cast(this.batchPredictionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBatchPredictionRequest, T> g) {
        return obj -> g.apply((UpdateBatchPredictionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String batchPredictionId;
        private String batchPredictionName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBatchPredictionRequest model) {
            super(model);
            this.batchPredictionId(model.batchPredictionId);
            this.batchPredictionName(model.batchPredictionName);
        }

        public final String getBatchPredictionId() {
            return this.batchPredictionId;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        @Override
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        public final String getBatchPredictionName() {
            return this.batchPredictionName;
        }

        public final void setBatchPredictionName(String batchPredictionName) {
            this.batchPredictionName = batchPredictionName;
        }

        @Override
        public final Builder batchPredictionName(String batchPredictionName) {
            this.batchPredictionName = batchPredictionName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBatchPredictionRequest build() {
            return new UpdateBatchPredictionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBatchPredictionRequest> {
        public Builder batchPredictionId(String var1);

        public Builder batchPredictionName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

