/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.m2.model.Definition;
import software.amazon.awssdk.services.m2.model.M2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationRequest
extends M2Request
implements ToCopyableBuilder<Builder, UpdateApplicationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::applicationId)).setter(UpdateApplicationRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<Integer> CURRENT_APPLICATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("currentApplicationVersion").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::currentApplicationVersion)).setter(UpdateApplicationRequest.setter(Builder::currentApplicationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentApplicationVersion").build()}).build();
    private static final SdkField<Definition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::definition)).setter(UpdateApplicationRequest.setter(Builder::definition)).constructor(Definition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::description)).setter(UpdateApplicationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CURRENT_APPLICATION_VERSION_FIELD, DEFINITION_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("currentApplicationVersion", CURRENT_APPLICATION_VERSION_FIELD);
            this.put("definition", DEFINITION_FIELD);
            this.put("description", DESCRIPTION_FIELD);
        }
    });
    private final String applicationId;
    private final Integer currentApplicationVersion;
    private final Definition definition;
    private final String description;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.currentApplicationVersion = builder.currentApplicationVersion;
        this.definition = builder.definition;
        this.description = builder.description;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final Integer currentApplicationVersion() {
        return this.currentApplicationVersion;
    }

    public final Definition definition() {
        return this.definition;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentApplicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.currentApplicationVersion(), other.currentApplicationVersion()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationRequest").add("ApplicationId", (Object)this.applicationId()).add("CurrentApplicationVersion", (Object)this.currentApplicationVersion()).add("Definition", (Object)this.definition()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "currentApplicationVersion": {
                return Optional.ofNullable(clazz.cast(this.currentApplicationVersion()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Request.BuilderImpl
    implements Builder {
        private String applicationId;
        private Integer currentApplicationVersion;
        private Definition definition;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.currentApplicationVersion(model.currentApplicationVersion);
            this.definition(model.definition);
            this.description(model.description);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Integer getCurrentApplicationVersion() {
            return this.currentApplicationVersion;
        }

        public final void setCurrentApplicationVersion(Integer currentApplicationVersion) {
            this.currentApplicationVersion = currentApplicationVersion;
        }

        @Override
        public final Builder currentApplicationVersion(Integer currentApplicationVersion) {
            this.currentApplicationVersion = currentApplicationVersion;
            return this;
        }

        public final Definition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(Definition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(Definition definition) {
            this.definition = definition;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends M2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationRequest> {
        public Builder applicationId(String var1);

        public Builder currentApplicationVersion(Integer var1);

        public Builder definition(Definition var1);

        default public Builder definition(Consumer<Definition.Builder> definition) {
            return this.definition((Definition)((Definition.Builder)Definition.builder().applyMutation(definition)).build());
        }

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

