/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus;
import software.amazon.awssdk.services.m2.model.BatchJobIdentifier;
import software.amazon.awssdk.services.m2.model.BatchJobType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchJobExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchJobExecutionSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(BatchJobExecutionSummary.getter(BatchJobExecutionSummary::applicationId)).setter(BatchJobExecutionSummary.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<BatchJobIdentifier> BATCH_JOB_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("batchJobIdentifier").getter(BatchJobExecutionSummary.getter(BatchJobExecutionSummary::batchJobIdentifier)).setter(BatchJobExecutionSummary.setter(Builder::batchJobIdentifier)).constructor(BatchJobIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchJobIdentifier").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(BatchJobExecutionSummary.getter(BatchJobExecutionSummary::endTime)).setter(BatchJobExecutionSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(BatchJobExecutionSummary.getter(BatchJobExecutionSummary::executionId)).setter(BatchJobExecutionSummary.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(BatchJobExecutionSummary.getter(BatchJobExecutionSummary::jobId)).setter(BatchJobExecutionSummary.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(BatchJobExecutionSummary.getter(BatchJobExecutionSummary::jobName)).setter(BatchJobExecutionSummary.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobType").getter(BatchJobExecutionSummary.getter(BatchJobExecutionSummary::jobTypeAsString)).setter(BatchJobExecutionSummary.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()}).build();
    private static final SdkField<String> RETURN_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("returnCode").getter(BatchJobExecutionSummary.getter(BatchJobExecutionSummary::returnCode)).setter(BatchJobExecutionSummary.setter(Builder::returnCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnCode").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(BatchJobExecutionSummary.getter(BatchJobExecutionSummary::startTime)).setter(BatchJobExecutionSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(BatchJobExecutionSummary.getter(BatchJobExecutionSummary::statusAsString)).setter(BatchJobExecutionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, BATCH_JOB_IDENTIFIER_FIELD, END_TIME_FIELD, EXECUTION_ID_FIELD, JOB_ID_FIELD, JOB_NAME_FIELD, JOB_TYPE_FIELD, RETURN_CODE_FIELD, START_TIME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("batchJobIdentifier", BATCH_JOB_IDENTIFIER_FIELD);
            this.put("endTime", END_TIME_FIELD);
            this.put("executionId", EXECUTION_ID_FIELD);
            this.put("jobId", JOB_ID_FIELD);
            this.put("jobName", JOB_NAME_FIELD);
            this.put("jobType", JOB_TYPE_FIELD);
            this.put("returnCode", RETURN_CODE_FIELD);
            this.put("startTime", START_TIME_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final BatchJobIdentifier batchJobIdentifier;
    private final Instant endTime;
    private final String executionId;
    private final String jobId;
    private final String jobName;
    private final String jobType;
    private final String returnCode;
    private final Instant startTime;
    private final String status;

    private BatchJobExecutionSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.batchJobIdentifier = builder.batchJobIdentifier;
        this.endTime = builder.endTime;
        this.executionId = builder.executionId;
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobType = builder.jobType;
        this.returnCode = builder.returnCode;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final BatchJobIdentifier batchJobIdentifier() {
        return this.batchJobIdentifier;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final BatchJobType jobType() {
        return BatchJobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final String returnCode() {
        return this.returnCode;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final BatchJobExecutionStatus status() {
        return BatchJobExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchJobExecutionSummary)) {
            return false;
        }
        BatchJobExecutionSummary other = (BatchJobExecutionSummary)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.batchJobIdentifier(), other.batchJobIdentifier()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.returnCode(), other.returnCode()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BatchJobExecutionSummary").add("ApplicationId", (Object)this.applicationId()).add("BatchJobIdentifier", (Object)this.batchJobIdentifier()).add("EndTime", (Object)this.endTime()).add("ExecutionId", (Object)this.executionId()).add("JobId", (Object)this.jobId()).add("JobName", (Object)this.jobName()).add("JobType", (Object)this.jobTypeAsString()).add("ReturnCode", (Object)this.returnCode()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "batchJobIdentifier": {
                return Optional.ofNullable(clazz.cast(this.batchJobIdentifier()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "jobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "returnCode": {
                return Optional.ofNullable(clazz.cast(this.returnCode()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchJobExecutionSummary, T> g) {
        return obj -> g.apply((BatchJobExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private BatchJobIdentifier batchJobIdentifier;
        private Instant endTime;
        private String executionId;
        private String jobId;
        private String jobName;
        private String jobType;
        private String returnCode;
        private Instant startTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchJobExecutionSummary model) {
            this.applicationId(model.applicationId);
            this.batchJobIdentifier(model.batchJobIdentifier);
            this.endTime(model.endTime);
            this.executionId(model.executionId);
            this.jobId(model.jobId);
            this.jobName(model.jobName);
            this.jobType(model.jobType);
            this.returnCode(model.returnCode);
            this.startTime(model.startTime);
            this.status(model.status);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final BatchJobIdentifier.Builder getBatchJobIdentifier() {
            return this.batchJobIdentifier != null ? this.batchJobIdentifier.toBuilder() : null;
        }

        public final void setBatchJobIdentifier(BatchJobIdentifier.BuilderImpl batchJobIdentifier) {
            this.batchJobIdentifier = batchJobIdentifier != null ? batchJobIdentifier.build() : null;
        }

        @Override
        public final Builder batchJobIdentifier(BatchJobIdentifier batchJobIdentifier) {
            this.batchJobIdentifier = batchJobIdentifier;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(BatchJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getReturnCode() {
            return this.returnCode;
        }

        public final void setReturnCode(String returnCode) {
            this.returnCode = returnCode;
        }

        @Override
        public final Builder returnCode(String returnCode) {
            this.returnCode = returnCode;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BatchJobExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public BatchJobExecutionSummary build() {
            return new BatchJobExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchJobExecutionSummary> {
        public Builder applicationId(String var1);

        public Builder batchJobIdentifier(BatchJobIdentifier var1);

        default public Builder batchJobIdentifier(Consumer<BatchJobIdentifier.Builder> batchJobIdentifier) {
            return this.batchJobIdentifier((BatchJobIdentifier)((BatchJobIdentifier.Builder)BatchJobIdentifier.builder().applyMutation(batchJobIdentifier)).build());
        }

        public Builder endTime(Instant var1);

        public Builder executionId(String var1);

        public Builder jobId(String var1);

        public Builder jobName(String var1);

        public Builder jobType(String var1);

        public Builder jobType(BatchJobType var1);

        public Builder returnCode(String var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(BatchJobExecutionStatus var1);
    }
}

