/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.SnsFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SNSConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SNSConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(SNSConfiguration.getter(SNSConfiguration::roleArn)).setter(SNSConfiguration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicArn").getter(SNSConfiguration.getter(SNSConfiguration::snsTopicArn)).setter(SNSConfiguration.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final SdkField<String> SNS_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsFormat").getter(SNSConfiguration.getter(SNSConfiguration::snsFormatAsString)).setter(SNSConfiguration.setter(Builder::snsFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, SNS_TOPIC_ARN_FIELD, SNS_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("SnsTopicArn", SNS_TOPIC_ARN_FIELD);
            this.put("SnsFormat", SNS_FORMAT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String snsTopicArn;
    private final String snsFormat;

    private SNSConfiguration(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.snsTopicArn = builder.snsTopicArn;
        this.snsFormat = builder.snsFormat;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public final SnsFormat snsFormat() {
        return SnsFormat.fromValue(this.snsFormat);
    }

    public final String snsFormatAsString() {
        return this.snsFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SNSConfiguration)) {
            return false;
        }
        SNSConfiguration other = (SNSConfiguration)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.snsFormatAsString(), other.snsFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SNSConfiguration").add("RoleArn", (Object)this.roleArn()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("SnsFormat", (Object)this.snsFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "SnsFormat": {
                return Optional.ofNullable(clazz.cast(this.snsFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SNSConfiguration, T> g) {
        return obj -> g.apply((SNSConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String snsTopicArn;
        private String snsFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(SNSConfiguration model) {
            this.roleArn(model.roleArn);
            this.snsTopicArn(model.snsTopicArn);
            this.snsFormat(model.snsFormat);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getSnsFormat() {
            return this.snsFormat;
        }

        public final void setSnsFormat(String snsFormat) {
            this.snsFormat = snsFormat;
        }

        @Override
        public final Builder snsFormat(String snsFormat) {
            this.snsFormat = snsFormat;
            return this;
        }

        @Override
        public final Builder snsFormat(SnsFormat snsFormat) {
            this.snsFormat(snsFormat == null ? null : snsFormat.toString());
            return this;
        }

        public SNSConfiguration build() {
            return new SNSConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SNSConfiguration> {
        public Builder roleArn(String var1);

        public Builder snsTopicArn(String var1);

        public Builder snsFormat(String var1);

        public Builder snsFormat(SnsFormat var1);
    }
}

