/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.TimeSeries;
import software.amazon.awssdk.services.lookoutmetrics.model.TimeSeriesListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.TimestampListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnomalyGroupTimeSeriesResponse
extends LookoutMetricsResponse
implements ToCopyableBuilder<Builder, ListAnomalyGroupTimeSeriesResponse> {
    private static final SdkField<String> ANOMALY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyGroupId").getter(ListAnomalyGroupTimeSeriesResponse.getter(ListAnomalyGroupTimeSeriesResponse::anomalyGroupId)).setter(ListAnomalyGroupTimeSeriesResponse.setter(Builder::anomalyGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupId").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(ListAnomalyGroupTimeSeriesResponse.getter(ListAnomalyGroupTimeSeriesResponse::metricName)).setter(ListAnomalyGroupTimeSeriesResponse.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<List<String>> TIMESTAMP_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TimestampList").getter(ListAnomalyGroupTimeSeriesResponse.getter(ListAnomalyGroupTimeSeriesResponse::timestampList)).setter(ListAnomalyGroupTimeSeriesResponse.setter(Builder::timestampList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAnomalyGroupTimeSeriesResponse.getter(ListAnomalyGroupTimeSeriesResponse::nextToken)).setter(ListAnomalyGroupTimeSeriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<TimeSeries>> TIME_SERIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TimeSeriesList").getter(ListAnomalyGroupTimeSeriesResponse.getter(ListAnomalyGroupTimeSeriesResponse::timeSeriesList)).setter(ListAnomalyGroupTimeSeriesResponse.setter(Builder::timeSeriesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeSeries::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_GROUP_ID_FIELD, METRIC_NAME_FIELD, TIMESTAMP_LIST_FIELD, NEXT_TOKEN_FIELD, TIME_SERIES_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AnomalyGroupId", ANOMALY_GROUP_ID_FIELD);
            this.put("MetricName", METRIC_NAME_FIELD);
            this.put("TimestampList", TIMESTAMP_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("TimeSeriesList", TIME_SERIES_LIST_FIELD);
        }
    });
    private final String anomalyGroupId;
    private final String metricName;
    private final List<String> timestampList;
    private final String nextToken;
    private final List<TimeSeries> timeSeriesList;

    private ListAnomalyGroupTimeSeriesResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyGroupId = builder.anomalyGroupId;
        this.metricName = builder.metricName;
        this.timestampList = builder.timestampList;
        this.nextToken = builder.nextToken;
        this.timeSeriesList = builder.timeSeriesList;
    }

    public final String anomalyGroupId() {
        return this.anomalyGroupId;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final boolean hasTimestampList() {
        return this.timestampList != null && !(this.timestampList instanceof SdkAutoConstructList);
    }

    public final List<String> timestampList() {
        return this.timestampList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTimeSeriesList() {
        return this.timeSeriesList != null && !(this.timeSeriesList instanceof SdkAutoConstructList);
    }

    public final List<TimeSeries> timeSeriesList() {
        return this.timeSeriesList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimestampList() ? this.timestampList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimeSeriesList() ? this.timeSeriesList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomalyGroupTimeSeriesResponse)) {
            return false;
        }
        ListAnomalyGroupTimeSeriesResponse other = (ListAnomalyGroupTimeSeriesResponse)((Object)obj);
        return Objects.equals(this.anomalyGroupId(), other.anomalyGroupId()) && Objects.equals(this.metricName(), other.metricName()) && this.hasTimestampList() == other.hasTimestampList() && Objects.equals(this.timestampList(), other.timestampList()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasTimeSeriesList() == other.hasTimeSeriesList() && Objects.equals(this.timeSeriesList(), other.timeSeriesList());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnomalyGroupTimeSeriesResponse").add("AnomalyGroupId", (Object)this.anomalyGroupId()).add("MetricName", (Object)this.metricName()).add("TimestampList", this.hasTimestampList() ? this.timestampList() : null).add("NextToken", (Object)this.nextToken()).add("TimeSeriesList", this.hasTimeSeriesList() ? this.timeSeriesList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyGroupId": {
                return Optional.ofNullable(clazz.cast(this.anomalyGroupId()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "TimestampList": {
                return Optional.ofNullable(clazz.cast(this.timestampList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TimeSeriesList": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAnomalyGroupTimeSeriesResponse, T> g) {
        return obj -> g.apply((ListAnomalyGroupTimeSeriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsResponse.BuilderImpl
    implements Builder {
        private String anomalyGroupId;
        private String metricName;
        private List<String> timestampList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private List<TimeSeries> timeSeriesList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomalyGroupTimeSeriesResponse model) {
            super(model);
            this.anomalyGroupId(model.anomalyGroupId);
            this.metricName(model.metricName);
            this.timestampList(model.timestampList);
            this.nextToken(model.nextToken);
            this.timeSeriesList(model.timeSeriesList);
        }

        public final String getAnomalyGroupId() {
            return this.anomalyGroupId;
        }

        public final void setAnomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
        }

        @Override
        public final Builder anomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final Collection<String> getTimestampList() {
            if (this.timestampList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.timestampList;
        }

        public final void setTimestampList(Collection<String> timestampList) {
            this.timestampList = TimestampListCopier.copy(timestampList);
        }

        @Override
        public final Builder timestampList(Collection<String> timestampList) {
            this.timestampList = TimestampListCopier.copy(timestampList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestampList(String ... timestampList) {
            this.timestampList(Arrays.asList(timestampList));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TimeSeries.Builder> getTimeSeriesList() {
            List<TimeSeries.Builder> result = TimeSeriesListCopier.copyToBuilder(this.timeSeriesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeSeriesList(Collection<TimeSeries.BuilderImpl> timeSeriesList) {
            this.timeSeriesList = TimeSeriesListCopier.copyFromBuilder(timeSeriesList);
        }

        @Override
        public final Builder timeSeriesList(Collection<TimeSeries> timeSeriesList) {
            this.timeSeriesList = TimeSeriesListCopier.copy(timeSeriesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesList(TimeSeries ... timeSeriesList) {
            this.timeSeriesList(Arrays.asList(timeSeriesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesList(Consumer<TimeSeries.Builder> ... timeSeriesList) {
            this.timeSeriesList(Stream.of(timeSeriesList).map(c -> (TimeSeries)((TimeSeries.Builder)TimeSeries.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAnomalyGroupTimeSeriesResponse build() {
            return new ListAnomalyGroupTimeSeriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutMetricsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnomalyGroupTimeSeriesResponse> {
        public Builder anomalyGroupId(String var1);

        public Builder metricName(String var1);

        public Builder timestampList(Collection<String> var1);

        public Builder timestampList(String ... var1);

        public Builder nextToken(String var1);

        public Builder timeSeriesList(Collection<TimeSeries> var1);

        public Builder timeSeriesList(TimeSeries ... var1);

        public Builder timeSeriesList(Consumer<TimeSeries.Builder> ... var1);
    }
}

