/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentAsyncClient;
import software.amazon.awssdk.services.lookoutequipment.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse;

public class ListLabelGroupsPublisher
implements SdkPublisher<ListLabelGroupsResponse> {
    private final LookoutEquipmentAsyncClient client;
    private final ListLabelGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLabelGroupsPublisher(LookoutEquipmentAsyncClient client, ListLabelGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLabelGroupsPublisher(LookoutEquipmentAsyncClient client, ListLabelGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLabelGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLabelGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListLabelGroupsResponseFetcher
    implements AsyncPageFetcher<ListLabelGroupsResponse> {
        private ListLabelGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListLabelGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLabelGroupsResponse> nextPage(ListLabelGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListLabelGroupsPublisher.this.client.listLabelGroups(ListLabelGroupsPublisher.this.firstRequest);
            }
            return ListLabelGroupsPublisher.this.client.listLabelGroups((ListLabelGroupsRequest)((Object)ListLabelGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

