/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelVersionSourceType {
    TRAINING("TRAINING"),
    RETRAINING("RETRAINING"),
    IMPORT("IMPORT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelVersionSourceType> VALUE_MAP;
    private final String value;

    private ModelVersionSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelVersionSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelVersionSourceType> knownValues() {
        EnumSet<ModelVersionSourceType> knownValues = EnumSet.allOf(ModelVersionSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelVersionSourceType.class, ModelVersionSourceType::toString);
    }
}

