/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.Place;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchForTextResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchForTextResult> {
    private static final SdkField<Place> PLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Place").getter(SearchForTextResult.getter(SearchForTextResult::place)).setter(SearchForTextResult.setter(Builder::place)).constructor(Place::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Place").build()}).build();
    private static final SdkField<Double> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Distance").getter(SearchForTextResult.getter(SearchForTextResult::distance)).setter(SearchForTextResult.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<Double> RELEVANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Relevance").getter(SearchForTextResult.getter(SearchForTextResult::relevance)).setter(SearchForTextResult.setter(Builder::relevance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relevance").build()}).build();
    private static final SdkField<String> PLACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaceId").getter(SearchForTextResult.getter(SearchForTextResult::placeId)).setter(SearchForTextResult.setter(Builder::placeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACE_FIELD, DISTANCE_FIELD, RELEVANCE_FIELD, PLACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Place", PLACE_FIELD);
            this.put("Distance", DISTANCE_FIELD);
            this.put("Relevance", RELEVANCE_FIELD);
            this.put("PlaceId", PLACE_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Place place;
    private final Double distance;
    private final Double relevance;
    private final String placeId;

    private SearchForTextResult(BuilderImpl builder) {
        this.place = builder.place;
        this.distance = builder.distance;
        this.relevance = builder.relevance;
        this.placeId = builder.placeId;
    }

    public final Place place() {
        return this.place;
    }

    public final Double distance() {
        return this.distance;
    }

    public final Double relevance() {
        return this.relevance;
    }

    public final String placeId() {
        return this.placeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.place());
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.relevance());
        hashCode = 31 * hashCode + Objects.hashCode(this.placeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchForTextResult)) {
            return false;
        }
        SearchForTextResult other = (SearchForTextResult)obj;
        return Objects.equals(this.place(), other.place()) && Objects.equals(this.distance(), other.distance()) && Objects.equals(this.relevance(), other.relevance()) && Objects.equals(this.placeId(), other.placeId());
    }

    public final String toString() {
        return ToString.builder((String)"SearchForTextResult").add("Place", (Object)this.place()).add("Distance", (Object)this.distance()).add("Relevance", (Object)this.relevance()).add("PlaceId", (Object)this.placeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Place": {
                return Optional.ofNullable(clazz.cast(this.place()));
            }
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "Relevance": {
                return Optional.ofNullable(clazz.cast(this.relevance()));
            }
            case "PlaceId": {
                return Optional.ofNullable(clazz.cast(this.placeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchForTextResult, T> g) {
        return obj -> g.apply((SearchForTextResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Place place;
        private Double distance;
        private Double relevance;
        private String placeId;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchForTextResult model) {
            this.place(model.place);
            this.distance(model.distance);
            this.relevance(model.relevance);
            this.placeId(model.placeId);
        }

        public final Place.Builder getPlace() {
            return this.place != null ? this.place.toBuilder() : null;
        }

        public final void setPlace(Place.BuilderImpl place) {
            this.place = place != null ? place.build() : null;
        }

        @Override
        public final Builder place(Place place) {
            this.place = place;
            return this;
        }

        public final Double getDistance() {
            return this.distance;
        }

        public final void setDistance(Double distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Double distance) {
            this.distance = distance;
            return this;
        }

        public final Double getRelevance() {
            return this.relevance;
        }

        public final void setRelevance(Double relevance) {
            this.relevance = relevance;
        }

        @Override
        public final Builder relevance(Double relevance) {
            this.relevance = relevance;
            return this;
        }

        public final String getPlaceId() {
            return this.placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public SearchForTextResult build() {
            return new SearchForTextResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchForTextResult> {
        public Builder place(Place var1);

        default public Builder place(Consumer<Place.Builder> place) {
            return this.place((Place)((Place.Builder)Place.builder().applyMutation(place)).build());
        }

        public Builder distance(Double var1);

        public Builder relevance(Double var1);

        public Builder placeId(String var1);
    }
}

