/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AccessRules;
import software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.PartnerIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBucketRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, UpdateBucketRequest> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(UpdateBucketRequest.getter(UpdateBucketRequest::bucketName)).setter(UpdateBucketRequest.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<AccessRules> ACCESS_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessRules").getter(UpdateBucketRequest.getter(UpdateBucketRequest::accessRules)).setter(UpdateBucketRequest.setter(Builder::accessRules)).constructor(AccessRules::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessRules").build()}).build();
    private static final SdkField<String> VERSIONING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versioning").getter(UpdateBucketRequest.getter(UpdateBucketRequest::versioning)).setter(UpdateBucketRequest.setter(Builder::versioning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versioning").build()}).build();
    private static final SdkField<List<String>> READONLY_ACCESS_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("readonlyAccessAccounts").getter(UpdateBucketRequest.getter(UpdateBucketRequest::readonlyAccessAccounts)).setter(UpdateBucketRequest.setter(Builder::readonlyAccessAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readonlyAccessAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BucketAccessLogConfig> ACCESS_LOG_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessLogConfig").getter(UpdateBucketRequest.getter(UpdateBucketRequest::accessLogConfig)).setter(UpdateBucketRequest.setter(Builder::accessLogConfig)).constructor(BucketAccessLogConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLogConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, ACCESS_RULES_FIELD, VERSIONING_FIELD, READONLY_ACCESS_ACCOUNTS_FIELD, ACCESS_LOG_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("bucketName", BUCKET_NAME_FIELD);
            this.put("accessRules", ACCESS_RULES_FIELD);
            this.put("versioning", VERSIONING_FIELD);
            this.put("readonlyAccessAccounts", READONLY_ACCESS_ACCOUNTS_FIELD);
            this.put("accessLogConfig", ACCESS_LOG_CONFIG_FIELD);
        }
    });
    private final String bucketName;
    private final AccessRules accessRules;
    private final String versioning;
    private final List<String> readonlyAccessAccounts;
    private final BucketAccessLogConfig accessLogConfig;

    private UpdateBucketRequest(BuilderImpl builder) {
        super(builder);
        this.bucketName = builder.bucketName;
        this.accessRules = builder.accessRules;
        this.versioning = builder.versioning;
        this.readonlyAccessAccounts = builder.readonlyAccessAccounts;
        this.accessLogConfig = builder.accessLogConfig;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final AccessRules accessRules() {
        return this.accessRules;
    }

    public final String versioning() {
        return this.versioning;
    }

    public final boolean hasReadonlyAccessAccounts() {
        return this.readonlyAccessAccounts != null && !(this.readonlyAccessAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> readonlyAccessAccounts() {
        return this.readonlyAccessAccounts;
    }

    public final BucketAccessLogConfig accessLogConfig() {
        return this.accessLogConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.versioning());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadonlyAccessAccounts() ? this.readonlyAccessAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLogConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBucketRequest)) {
            return false;
        }
        UpdateBucketRequest other = (UpdateBucketRequest)((Object)obj);
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.accessRules(), other.accessRules()) && Objects.equals(this.versioning(), other.versioning()) && this.hasReadonlyAccessAccounts() == other.hasReadonlyAccessAccounts() && Objects.equals(this.readonlyAccessAccounts(), other.readonlyAccessAccounts()) && Objects.equals(this.accessLogConfig(), other.accessLogConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBucketRequest").add("BucketName", (Object)this.bucketName()).add("AccessRules", (Object)this.accessRules()).add("Versioning", (Object)this.versioning()).add("ReadonlyAccessAccounts", this.hasReadonlyAccessAccounts() ? this.readonlyAccessAccounts() : null).add("AccessLogConfig", (Object)this.accessLogConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "accessRules": {
                return Optional.ofNullable(clazz.cast(this.accessRules()));
            }
            case "versioning": {
                return Optional.ofNullable(clazz.cast(this.versioning()));
            }
            case "readonlyAccessAccounts": {
                return Optional.ofNullable(clazz.cast(this.readonlyAccessAccounts()));
            }
            case "accessLogConfig": {
                return Optional.ofNullable(clazz.cast(this.accessLogConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBucketRequest, T> g) {
        return obj -> g.apply((UpdateBucketRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String bucketName;
        private AccessRules accessRules;
        private String versioning;
        private List<String> readonlyAccessAccounts = DefaultSdkAutoConstructList.getInstance();
        private BucketAccessLogConfig accessLogConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBucketRequest model) {
            super(model);
            this.bucketName(model.bucketName);
            this.accessRules(model.accessRules);
            this.versioning(model.versioning);
            this.readonlyAccessAccounts(model.readonlyAccessAccounts);
            this.accessLogConfig(model.accessLogConfig);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final AccessRules.Builder getAccessRules() {
            return this.accessRules != null ? this.accessRules.toBuilder() : null;
        }

        public final void setAccessRules(AccessRules.BuilderImpl accessRules) {
            this.accessRules = accessRules != null ? accessRules.build() : null;
        }

        @Override
        public final Builder accessRules(AccessRules accessRules) {
            this.accessRules = accessRules;
            return this;
        }

        public final String getVersioning() {
            return this.versioning;
        }

        public final void setVersioning(String versioning) {
            this.versioning = versioning;
        }

        @Override
        public final Builder versioning(String versioning) {
            this.versioning = versioning;
            return this;
        }

        public final Collection<String> getReadonlyAccessAccounts() {
            if (this.readonlyAccessAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.readonlyAccessAccounts;
        }

        public final void setReadonlyAccessAccounts(Collection<String> readonlyAccessAccounts) {
            this.readonlyAccessAccounts = PartnerIdListCopier.copy(readonlyAccessAccounts);
        }

        @Override
        public final Builder readonlyAccessAccounts(Collection<String> readonlyAccessAccounts) {
            this.readonlyAccessAccounts = PartnerIdListCopier.copy(readonlyAccessAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readonlyAccessAccounts(String ... readonlyAccessAccounts) {
            this.readonlyAccessAccounts(Arrays.asList(readonlyAccessAccounts));
            return this;
        }

        public final BucketAccessLogConfig.Builder getAccessLogConfig() {
            return this.accessLogConfig != null ? this.accessLogConfig.toBuilder() : null;
        }

        public final void setAccessLogConfig(BucketAccessLogConfig.BuilderImpl accessLogConfig) {
            this.accessLogConfig = accessLogConfig != null ? accessLogConfig.build() : null;
        }

        @Override
        public final Builder accessLogConfig(BucketAccessLogConfig accessLogConfig) {
            this.accessLogConfig = accessLogConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBucketRequest build() {
            return new UpdateBucketRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBucketRequest> {
        public Builder bucketName(String var1);

        public Builder accessRules(AccessRules var1);

        default public Builder accessRules(Consumer<AccessRules.Builder> accessRules) {
            return this.accessRules((AccessRules)((AccessRules.Builder)AccessRules.builder().applyMutation(accessRules)).build());
        }

        public Builder versioning(String var1);

        public Builder readonlyAccessAccounts(Collection<String> var1);

        public Builder readonlyAccessAccounts(String ... var1);

        public Builder accessLogConfig(BucketAccessLogConfig var1);

        default public Builder accessLogConfig(Consumer<BucketAccessLogConfig.Builder> accessLogConfig) {
            return this.accessLogConfig((BucketAccessLogConfig)((BucketAccessLogConfig.Builder)BucketAccessLogConfig.builder().applyMutation(accessLogConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

