/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.CertificateProvider;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.SetupDomainNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetupInstanceHttpsRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, SetupInstanceHttpsRequest> {
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceName").getter(SetupInstanceHttpsRequest.getter(SetupInstanceHttpsRequest::instanceName)).setter(SetupInstanceHttpsRequest.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("emailAddress").getter(SetupInstanceHttpsRequest.getter(SetupInstanceHttpsRequest::emailAddress)).setter(SetupInstanceHttpsRequest.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()}).build();
    private static final SdkField<List<String>> DOMAIN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("domainNames").getter(SetupInstanceHttpsRequest.getter(SetupInstanceHttpsRequest::domainNames)).setter(SetupInstanceHttpsRequest.setter(Builder::domainNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CERTIFICATE_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateProvider").getter(SetupInstanceHttpsRequest.getter(SetupInstanceHttpsRequest::certificateProviderAsString)).setter(SetupInstanceHttpsRequest.setter(Builder::certificateProvider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateProvider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAME_FIELD, EMAIL_ADDRESS_FIELD, DOMAIN_NAMES_FIELD, CERTIFICATE_PROVIDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("instanceName", INSTANCE_NAME_FIELD);
            this.put("emailAddress", EMAIL_ADDRESS_FIELD);
            this.put("domainNames", DOMAIN_NAMES_FIELD);
            this.put("certificateProvider", CERTIFICATE_PROVIDER_FIELD);
        }
    });
    private final String instanceName;
    private final String emailAddress;
    private final List<String> domainNames;
    private final String certificateProvider;

    private SetupInstanceHttpsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceName = builder.instanceName;
        this.emailAddress = builder.emailAddress;
        this.domainNames = builder.domainNames;
        this.certificateProvider = builder.certificateProvider;
    }

    public final String instanceName() {
        return this.instanceName;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final boolean hasDomainNames() {
        return this.domainNames != null && !(this.domainNames instanceof SdkAutoConstructList);
    }

    public final List<String> domainNames() {
        return this.domainNames;
    }

    public final CertificateProvider certificateProvider() {
        return CertificateProvider.fromValue(this.certificateProvider);
    }

    public final String certificateProviderAsString() {
        return this.certificateProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainNames() ? this.domainNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateProviderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetupInstanceHttpsRequest)) {
            return false;
        }
        SetupInstanceHttpsRequest other = (SetupInstanceHttpsRequest)((Object)obj);
        return Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.emailAddress(), other.emailAddress()) && this.hasDomainNames() == other.hasDomainNames() && Objects.equals(this.domainNames(), other.domainNames()) && Objects.equals(this.certificateProviderAsString(), other.certificateProviderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SetupInstanceHttpsRequest").add("InstanceName", (Object)this.instanceName()).add("EmailAddress", (Object)(this.emailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainNames", this.hasDomainNames() ? this.domainNames() : null).add("CertificateProvider", (Object)this.certificateProviderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "emailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "domainNames": {
                return Optional.ofNullable(clazz.cast(this.domainNames()));
            }
            case "certificateProvider": {
                return Optional.ofNullable(clazz.cast(this.certificateProviderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SetupInstanceHttpsRequest, T> g) {
        return obj -> g.apply((SetupInstanceHttpsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String instanceName;
        private String emailAddress;
        private List<String> domainNames = DefaultSdkAutoConstructList.getInstance();
        private String certificateProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(SetupInstanceHttpsRequest model) {
            super(model);
            this.instanceName(model.instanceName);
            this.emailAddress(model.emailAddress);
            this.domainNames(model.domainNames);
            this.certificateProvider(model.certificateProvider);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final Collection<String> getDomainNames() {
            if (this.domainNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domainNames;
        }

        public final void setDomainNames(Collection<String> domainNames) {
            this.domainNames = SetupDomainNameListCopier.copy(domainNames);
        }

        @Override
        public final Builder domainNames(Collection<String> domainNames) {
            this.domainNames = SetupDomainNameListCopier.copy(domainNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNames(String ... domainNames) {
            this.domainNames(Arrays.asList(domainNames));
            return this;
        }

        public final String getCertificateProvider() {
            return this.certificateProvider;
        }

        public final void setCertificateProvider(String certificateProvider) {
            this.certificateProvider = certificateProvider;
        }

        @Override
        public final Builder certificateProvider(String certificateProvider) {
            this.certificateProvider = certificateProvider;
            return this;
        }

        @Override
        public final Builder certificateProvider(CertificateProvider certificateProvider) {
            this.certificateProvider(certificateProvider == null ? null : certificateProvider.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetupInstanceHttpsRequest build() {
            return new SetupInstanceHttpsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetupInstanceHttpsRequest> {
        public Builder instanceName(String var1);

        public Builder emailAddress(String var1);

        public Builder domainNames(Collection<String> var1);

        public Builder domainNames(String ... var1);

        public Builder certificateProvider(String var1);

        public Builder certificateProvider(CertificateProvider var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

