/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary;
import software.amazon.awssdk.services.lightsail.model.InstanceHealthSummaryListCopier;
import software.amazon.awssdk.services.lightsail.model.IpAddressType;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerConfigurationOptionsCopier;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerState;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummaryListCopier;
import software.amazon.awssdk.services.lightsail.model.PortListCopier;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoadBalancer> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(LoadBalancer.getter(LoadBalancer::name)).setter(LoadBalancer.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(LoadBalancer.getter(LoadBalancer::arn)).setter(LoadBalancer.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("supportCode").getter(LoadBalancer.getter(LoadBalancer::supportCode)).setter(LoadBalancer.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(LoadBalancer.getter(LoadBalancer::createdAt)).setter(LoadBalancer.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(LoadBalancer.getter(LoadBalancer::location)).setter(LoadBalancer.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(LoadBalancer.getter(LoadBalancer::resourceTypeAsString)).setter(LoadBalancer.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(LoadBalancer.getter(LoadBalancer::tags)).setter(LoadBalancer.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnsName").getter(LoadBalancer.getter(LoadBalancer::dnsName)).setter(LoadBalancer.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(LoadBalancer.getter(LoadBalancer::stateAsString)).setter(LoadBalancer.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(LoadBalancer.getter(LoadBalancer::protocolAsString)).setter(LoadBalancer.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<List<Integer>> PUBLIC_PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("publicPorts").getter(LoadBalancer.getter(LoadBalancer::publicPorts)).setter(LoadBalancer.setter(Builder::publicPorts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicPorts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("healthCheckPath").getter(LoadBalancer.getter(LoadBalancer::healthCheckPath)).setter(LoadBalancer.setter(Builder::healthCheckPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckPath").build()}).build();
    private static final SdkField<Integer> INSTANCE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("instancePort").getter(LoadBalancer.getter(LoadBalancer::instancePort)).setter(LoadBalancer.setter(Builder::instancePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instancePort").build()}).build();
    private static final SdkField<List<InstanceHealthSummary>> INSTANCE_HEALTH_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceHealthSummary").getter(LoadBalancer.getter(LoadBalancer::instanceHealthSummary)).setter(LoadBalancer.setter(Builder::instanceHealthSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceHealthSummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceHealthSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LoadBalancerTlsCertificateSummary>> TLS_CERTIFICATE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tlsCertificateSummaries").getter(LoadBalancer.getter(LoadBalancer::tlsCertificateSummaries)).setter(LoadBalancer.setter(Builder::tlsCertificateSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsCertificateSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancerTlsCertificateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CONFIGURATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("configurationOptions").getter(LoadBalancer.getter(LoadBalancer::configurationOptionsAsStrings)).setter(LoadBalancer.setter(Builder::configurationOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddressType").getter(LoadBalancer.getter(LoadBalancer::ipAddressTypeAsString)).setter(LoadBalancer.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()}).build();
    private static final SdkField<Boolean> HTTPS_REDIRECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("httpsRedirectionEnabled").getter(LoadBalancer.getter(LoadBalancer::httpsRedirectionEnabled)).setter(LoadBalancer.setter(Builder::httpsRedirectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpsRedirectionEnabled").build()}).build();
    private static final SdkField<String> TLS_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tlsPolicyName").getter(LoadBalancer.getter(LoadBalancer::tlsPolicyName)).setter(LoadBalancer.setter(Builder::tlsPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsPolicyName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD, DNS_NAME_FIELD, STATE_FIELD, PROTOCOL_FIELD, PUBLIC_PORTS_FIELD, HEALTH_CHECK_PATH_FIELD, INSTANCE_PORT_FIELD, INSTANCE_HEALTH_SUMMARY_FIELD, TLS_CERTIFICATE_SUMMARIES_FIELD, CONFIGURATION_OPTIONS_FIELD, IP_ADDRESS_TYPE_FIELD, HTTPS_REDIRECTION_ENABLED_FIELD, TLS_POLICY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("supportCode", SUPPORT_CODE_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("location", LOCATION_FIELD);
            this.put("resourceType", RESOURCE_TYPE_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("dnsName", DNS_NAME_FIELD);
            this.put("state", STATE_FIELD);
            this.put("protocol", PROTOCOL_FIELD);
            this.put("publicPorts", PUBLIC_PORTS_FIELD);
            this.put("healthCheckPath", HEALTH_CHECK_PATH_FIELD);
            this.put("instancePort", INSTANCE_PORT_FIELD);
            this.put("instanceHealthSummary", INSTANCE_HEALTH_SUMMARY_FIELD);
            this.put("tlsCertificateSummaries", TLS_CERTIFICATE_SUMMARIES_FIELD);
            this.put("configurationOptions", CONFIGURATION_OPTIONS_FIELD);
            this.put("ipAddressType", IP_ADDRESS_TYPE_FIELD);
            this.put("httpsRedirectionEnabled", HTTPS_REDIRECTION_ENABLED_FIELD);
            this.put("tlsPolicyName", TLS_POLICY_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final List<Tag> tags;
    private final String dnsName;
    private final String state;
    private final String protocol;
    private final List<Integer> publicPorts;
    private final String healthCheckPath;
    private final Integer instancePort;
    private final List<InstanceHealthSummary> instanceHealthSummary;
    private final List<LoadBalancerTlsCertificateSummary> tlsCertificateSummaries;
    private final Map<String, String> configurationOptions;
    private final String ipAddressType;
    private final Boolean httpsRedirectionEnabled;
    private final String tlsPolicyName;

    private LoadBalancer(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
        this.dnsName = builder.dnsName;
        this.state = builder.state;
        this.protocol = builder.protocol;
        this.publicPorts = builder.publicPorts;
        this.healthCheckPath = builder.healthCheckPath;
        this.instancePort = builder.instancePort;
        this.instanceHealthSummary = builder.instanceHealthSummary;
        this.tlsCertificateSummaries = builder.tlsCertificateSummaries;
        this.configurationOptions = builder.configurationOptions;
        this.ipAddressType = builder.ipAddressType;
        this.httpsRedirectionEnabled = builder.httpsRedirectionEnabled;
        this.tlsPolicyName = builder.tlsPolicyName;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String supportCode() {
        return this.supportCode;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ResourceLocation location() {
        return this.location;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final LoadBalancerState state() {
        return LoadBalancerState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final LoadBalancerProtocol protocol() {
        return LoadBalancerProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final boolean hasPublicPorts() {
        return this.publicPorts != null && !(this.publicPorts instanceof SdkAutoConstructList);
    }

    public final List<Integer> publicPorts() {
        return this.publicPorts;
    }

    public final String healthCheckPath() {
        return this.healthCheckPath;
    }

    public final Integer instancePort() {
        return this.instancePort;
    }

    public final boolean hasInstanceHealthSummary() {
        return this.instanceHealthSummary != null && !(this.instanceHealthSummary instanceof SdkAutoConstructList);
    }

    public final List<InstanceHealthSummary> instanceHealthSummary() {
        return this.instanceHealthSummary;
    }

    public final boolean hasTlsCertificateSummaries() {
        return this.tlsCertificateSummaries != null && !(this.tlsCertificateSummaries instanceof SdkAutoConstructList);
    }

    public final List<LoadBalancerTlsCertificateSummary> tlsCertificateSummaries() {
        return this.tlsCertificateSummaries;
    }

    public final Map<LoadBalancerAttributeName, String> configurationOptions() {
        return LoadBalancerConfigurationOptionsCopier.copyStringToEnum(this.configurationOptions);
    }

    public final boolean hasConfigurationOptions() {
        return this.configurationOptions != null && !(this.configurationOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> configurationOptionsAsStrings() {
        return this.configurationOptions;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final Boolean httpsRedirectionEnabled() {
        return this.httpsRedirectionEnabled;
    }

    public final String tlsPolicyName() {
        return this.tlsPolicyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublicPorts() ? this.publicPorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceHealthSummary() ? this.instanceHealthSummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTlsCertificateSummaries() ? this.tlsCertificateSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationOptions() ? this.configurationOptionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpsRedirectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsPolicyName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancer)) {
            return false;
        }
        LoadBalancer other = (LoadBalancer)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && this.hasPublicPorts() == other.hasPublicPorts() && Objects.equals(this.publicPorts(), other.publicPorts()) && Objects.equals(this.healthCheckPath(), other.healthCheckPath()) && Objects.equals(this.instancePort(), other.instancePort()) && this.hasInstanceHealthSummary() == other.hasInstanceHealthSummary() && Objects.equals(this.instanceHealthSummary(), other.instanceHealthSummary()) && this.hasTlsCertificateSummaries() == other.hasTlsCertificateSummaries() && Objects.equals(this.tlsCertificateSummaries(), other.tlsCertificateSummaries()) && this.hasConfigurationOptions() == other.hasConfigurationOptions() && Objects.equals(this.configurationOptionsAsStrings(), other.configurationOptionsAsStrings()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.httpsRedirectionEnabled(), other.httpsRedirectionEnabled()) && Objects.equals(this.tlsPolicyName(), other.tlsPolicyName());
    }

    public final String toString() {
        return ToString.builder((String)"LoadBalancer").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("SupportCode", (Object)this.supportCode()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("DnsName", (Object)this.dnsName()).add("State", (Object)this.stateAsString()).add("Protocol", (Object)this.protocolAsString()).add("PublicPorts", this.hasPublicPorts() ? this.publicPorts() : null).add("HealthCheckPath", (Object)this.healthCheckPath()).add("InstancePort", (Object)this.instancePort()).add("InstanceHealthSummary", this.hasInstanceHealthSummary() ? this.instanceHealthSummary() : null).add("TlsCertificateSummaries", this.hasTlsCertificateSummaries() ? this.tlsCertificateSummaries() : null).add("ConfigurationOptions", this.hasConfigurationOptions() ? this.configurationOptionsAsStrings() : null).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("HttpsRedirectionEnabled", (Object)this.httpsRedirectionEnabled()).add("TlsPolicyName", (Object)this.tlsPolicyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "dnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "publicPorts": {
                return Optional.ofNullable(clazz.cast(this.publicPorts()));
            }
            case "healthCheckPath": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPath()));
            }
            case "instancePort": {
                return Optional.ofNullable(clazz.cast(this.instancePort()));
            }
            case "instanceHealthSummary": {
                return Optional.ofNullable(clazz.cast(this.instanceHealthSummary()));
            }
            case "tlsCertificateSummaries": {
                return Optional.ofNullable(clazz.cast(this.tlsCertificateSummaries()));
            }
            case "configurationOptions": {
                return Optional.ofNullable(clazz.cast(this.configurationOptionsAsStrings()));
            }
            case "ipAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "httpsRedirectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.httpsRedirectionEnabled()));
            }
            case "tlsPolicyName": {
                return Optional.ofNullable(clazz.cast(this.tlsPolicyName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancer, T> g) {
        return obj -> g.apply((LoadBalancer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String dnsName;
        private String state;
        private String protocol;
        private List<Integer> publicPorts = DefaultSdkAutoConstructList.getInstance();
        private String healthCheckPath;
        private Integer instancePort;
        private List<InstanceHealthSummary> instanceHealthSummary = DefaultSdkAutoConstructList.getInstance();
        private List<LoadBalancerTlsCertificateSummary> tlsCertificateSummaries = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> configurationOptions = DefaultSdkAutoConstructMap.getInstance();
        private String ipAddressType;
        private Boolean httpsRedirectionEnabled;
        private String tlsPolicyName;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancer model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.tags(model.tags);
            this.dnsName(model.dnsName);
            this.state(model.state);
            this.protocol(model.protocol);
            this.publicPorts(model.publicPorts);
            this.healthCheckPath(model.healthCheckPath);
            this.instancePort(model.instancePort);
            this.instanceHealthSummary(model.instanceHealthSummary);
            this.tlsCertificateSummaries(model.tlsCertificateSummaries);
            this.configurationOptionsWithStrings(model.configurationOptions);
            this.ipAddressType(model.ipAddressType);
            this.httpsRedirectionEnabled(model.httpsRedirectionEnabled);
            this.tlsPolicyName(model.tlsPolicyName);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(LoadBalancerState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(LoadBalancerProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Collection<Integer> getPublicPorts() {
            if (this.publicPorts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.publicPorts;
        }

        public final void setPublicPorts(Collection<Integer> publicPorts) {
            this.publicPorts = PortListCopier.copy(publicPorts);
        }

        @Override
        public final Builder publicPorts(Collection<Integer> publicPorts) {
            this.publicPorts = PortListCopier.copy(publicPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicPorts(Integer ... publicPorts) {
            this.publicPorts(Arrays.asList(publicPorts));
            return this;
        }

        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final Integer getInstancePort() {
            return this.instancePort;
        }

        public final void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        @Override
        public final Builder instancePort(Integer instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        public final List<InstanceHealthSummary.Builder> getInstanceHealthSummary() {
            List<InstanceHealthSummary.Builder> result = InstanceHealthSummaryListCopier.copyToBuilder(this.instanceHealthSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceHealthSummary(Collection<InstanceHealthSummary.BuilderImpl> instanceHealthSummary) {
            this.instanceHealthSummary = InstanceHealthSummaryListCopier.copyFromBuilder(instanceHealthSummary);
        }

        @Override
        public final Builder instanceHealthSummary(Collection<InstanceHealthSummary> instanceHealthSummary) {
            this.instanceHealthSummary = InstanceHealthSummaryListCopier.copy(instanceHealthSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceHealthSummary(InstanceHealthSummary ... instanceHealthSummary) {
            this.instanceHealthSummary(Arrays.asList(instanceHealthSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceHealthSummary(Consumer<InstanceHealthSummary.Builder> ... instanceHealthSummary) {
            this.instanceHealthSummary(Stream.of(instanceHealthSummary).map(c -> (InstanceHealthSummary)((InstanceHealthSummary.Builder)InstanceHealthSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LoadBalancerTlsCertificateSummary.Builder> getTlsCertificateSummaries() {
            List<LoadBalancerTlsCertificateSummary.Builder> result = LoadBalancerTlsCertificateSummaryListCopier.copyToBuilder(this.tlsCertificateSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTlsCertificateSummaries(Collection<LoadBalancerTlsCertificateSummary.BuilderImpl> tlsCertificateSummaries) {
            this.tlsCertificateSummaries = LoadBalancerTlsCertificateSummaryListCopier.copyFromBuilder(tlsCertificateSummaries);
        }

        @Override
        public final Builder tlsCertificateSummaries(Collection<LoadBalancerTlsCertificateSummary> tlsCertificateSummaries) {
            this.tlsCertificateSummaries = LoadBalancerTlsCertificateSummaryListCopier.copy(tlsCertificateSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tlsCertificateSummaries(LoadBalancerTlsCertificateSummary ... tlsCertificateSummaries) {
            this.tlsCertificateSummaries(Arrays.asList(tlsCertificateSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tlsCertificateSummaries(Consumer<LoadBalancerTlsCertificateSummary.Builder> ... tlsCertificateSummaries) {
            this.tlsCertificateSummaries(Stream.of(tlsCertificateSummaries).map(c -> (LoadBalancerTlsCertificateSummary)((LoadBalancerTlsCertificateSummary.Builder)LoadBalancerTlsCertificateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getConfigurationOptions() {
            if (this.configurationOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.configurationOptions;
        }

        public final void setConfigurationOptions(Map<String, String> configurationOptions) {
            this.configurationOptions = LoadBalancerConfigurationOptionsCopier.copy(configurationOptions);
        }

        @Override
        public final Builder configurationOptionsWithStrings(Map<String, String> configurationOptions) {
            this.configurationOptions = LoadBalancerConfigurationOptionsCopier.copy(configurationOptions);
            return this;
        }

        @Override
        public final Builder configurationOptions(Map<LoadBalancerAttributeName, String> configurationOptions) {
            this.configurationOptions = LoadBalancerConfigurationOptionsCopier.copyEnumToString(configurationOptions);
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final Boolean getHttpsRedirectionEnabled() {
            return this.httpsRedirectionEnabled;
        }

        public final void setHttpsRedirectionEnabled(Boolean httpsRedirectionEnabled) {
            this.httpsRedirectionEnabled = httpsRedirectionEnabled;
        }

        @Override
        public final Builder httpsRedirectionEnabled(Boolean httpsRedirectionEnabled) {
            this.httpsRedirectionEnabled = httpsRedirectionEnabled;
            return this;
        }

        public final String getTlsPolicyName() {
            return this.tlsPolicyName;
        }

        public final void setTlsPolicyName(String tlsPolicyName) {
            this.tlsPolicyName = tlsPolicyName;
        }

        @Override
        public final Builder tlsPolicyName(String tlsPolicyName) {
            this.tlsPolicyName = tlsPolicyName;
            return this;
        }

        public LoadBalancer build() {
            return new LoadBalancer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoadBalancer> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder dnsName(String var1);

        public Builder state(String var1);

        public Builder state(LoadBalancerState var1);

        public Builder protocol(String var1);

        public Builder protocol(LoadBalancerProtocol var1);

        public Builder publicPorts(Collection<Integer> var1);

        public Builder publicPorts(Integer ... var1);

        public Builder healthCheckPath(String var1);

        public Builder instancePort(Integer var1);

        public Builder instanceHealthSummary(Collection<InstanceHealthSummary> var1);

        public Builder instanceHealthSummary(InstanceHealthSummary ... var1);

        public Builder instanceHealthSummary(Consumer<InstanceHealthSummary.Builder> ... var1);

        public Builder tlsCertificateSummaries(Collection<LoadBalancerTlsCertificateSummary> var1);

        public Builder tlsCertificateSummaries(LoadBalancerTlsCertificateSummary ... var1);

        public Builder tlsCertificateSummaries(Consumer<LoadBalancerTlsCertificateSummary.Builder> ... var1);

        public Builder configurationOptionsWithStrings(Map<String, String> var1);

        public Builder configurationOptions(Map<LoadBalancerAttributeName, String> var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder httpsRedirectionEnabled(Boolean var1);

        public Builder tlsPolicyName(String var1);
    }
}

