/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DownloadDefaultKeyPairResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, DownloadDefaultKeyPairResponse> {
    private static final SdkField<String> PUBLIC_KEY_BASE64_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publicKeyBase64").getter(DownloadDefaultKeyPairResponse.getter(DownloadDefaultKeyPairResponse::publicKeyBase64)).setter(DownloadDefaultKeyPairResponse.setter(Builder::publicKeyBase64)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicKeyBase64").build()}).build();
    private static final SdkField<String> PRIVATE_KEY_BASE64_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privateKeyBase64").getter(DownloadDefaultKeyPairResponse.getter(DownloadDefaultKeyPairResponse::privateKeyBase64)).setter(DownloadDefaultKeyPairResponse.setter(Builder::privateKeyBase64)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateKeyBase64").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DownloadDefaultKeyPairResponse.getter(DownloadDefaultKeyPairResponse::createdAt)).setter(DownloadDefaultKeyPairResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEY_BASE64_FIELD, PRIVATE_KEY_BASE64_FIELD, CREATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("publicKeyBase64", PUBLIC_KEY_BASE64_FIELD);
            this.put("privateKeyBase64", PRIVATE_KEY_BASE64_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
        }
    });
    private final String publicKeyBase64;
    private final String privateKeyBase64;
    private final Instant createdAt;

    private DownloadDefaultKeyPairResponse(BuilderImpl builder) {
        super(builder);
        this.publicKeyBase64 = builder.publicKeyBase64;
        this.privateKeyBase64 = builder.privateKeyBase64;
        this.createdAt = builder.createdAt;
    }

    public final String publicKeyBase64() {
        return this.publicKeyBase64;
    }

    public final String privateKeyBase64() {
        return this.privateKeyBase64;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyBase64());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKeyBase64());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DownloadDefaultKeyPairResponse)) {
            return false;
        }
        DownloadDefaultKeyPairResponse other = (DownloadDefaultKeyPairResponse)((Object)obj);
        return Objects.equals(this.publicKeyBase64(), other.publicKeyBase64()) && Objects.equals(this.privateKeyBase64(), other.privateKeyBase64()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"DownloadDefaultKeyPairResponse").add("PublicKeyBase64", (Object)this.publicKeyBase64()).add("PrivateKeyBase64", (Object)this.privateKeyBase64()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "publicKeyBase64": {
                return Optional.ofNullable(clazz.cast(this.publicKeyBase64()));
            }
            case "privateKeyBase64": {
                return Optional.ofNullable(clazz.cast(this.privateKeyBase64()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DownloadDefaultKeyPairResponse, T> g) {
        return obj -> g.apply((DownloadDefaultKeyPairResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private String publicKeyBase64;
        private String privateKeyBase64;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DownloadDefaultKeyPairResponse model) {
            super(model);
            this.publicKeyBase64(model.publicKeyBase64);
            this.privateKeyBase64(model.privateKeyBase64);
            this.createdAt(model.createdAt);
        }

        public final String getPublicKeyBase64() {
            return this.publicKeyBase64;
        }

        public final void setPublicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
        }

        @Override
        public final Builder publicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
            return this;
        }

        public final String getPrivateKeyBase64() {
            return this.privateKeyBase64;
        }

        public final void setPrivateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
        }

        @Override
        public final Builder privateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public DownloadDefaultKeyPairResponse build() {
            return new DownloadDefaultKeyPairResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DownloadDefaultKeyPairResponse> {
        public Builder publicKeyBase64(String var1);

        public Builder privateKeyBase64(String var1);

        public Builder createdAt(Instant var1);
    }
}

