/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AllowedOperation {
    CREATE_GRANT("CreateGrant"),
    CHECKOUT_LICENSE("CheckoutLicense"),
    CHECKOUT_BORROW_LICENSE("CheckoutBorrowLicense"),
    CHECK_IN_LICENSE("CheckInLicense"),
    EXTEND_CONSUMPTION_LICENSE("ExtendConsumptionLicense"),
    LIST_PURCHASED_LICENSES("ListPurchasedLicenses"),
    CREATE_TOKEN("CreateToken"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AllowedOperation> VALUE_MAP;
    private final String value;

    private AllowedOperation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AllowedOperation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AllowedOperation> knownValues() {
        EnumSet<AllowedOperation> knownValues = EnumSet.allOf(AllowedOperation.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AllowedOperation.class, AllowedOperation::toString);
    }
}

