/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TestResultTypeFilter {
    OVERALL_TEST_RESULTS("OverallTestResults"),
    CONVERSATION_LEVEL_TEST_RESULTS("ConversationLevelTestResults"),
    INTENT_CLASSIFICATION_TEST_RESULTS("IntentClassificationTestResults"),
    SLOT_RESOLUTION_TEST_RESULTS("SlotResolutionTestResults"),
    UTTERANCE_LEVEL_RESULTS("UtteranceLevelResults"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TestResultTypeFilter> VALUE_MAP;
    private final String value;

    private TestResultTypeFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TestResultTypeFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TestResultTypeFilter> knownValues() {
        EnumSet<TestResultTypeFilter> knownValues = EnumSet.allOf(TestResultTypeFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TestResultTypeFilter.class, TestResultTypeFilter::toString);
    }
}

