/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsResponse;

public class GetSlotTypeVersionsIterable
implements SdkIterable<GetSlotTypeVersionsResponse> {
    private final LexModelBuildingClient client;
    private final GetSlotTypeVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSlotTypeVersionsIterable(LexModelBuildingClient client, GetSlotTypeVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetSlotTypeVersionsResponseFetcher();
    }

    public Iterator<GetSlotTypeVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetSlotTypeVersionsResponseFetcher
    implements SyncPageFetcher<GetSlotTypeVersionsResponse> {
        private GetSlotTypeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetSlotTypeVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetSlotTypeVersionsResponse nextPage(GetSlotTypeVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetSlotTypeVersionsIterable.this.client.getSlotTypeVersions(GetSlotTypeVersionsIterable.this.firstRequest);
            }
            return GetSlotTypeVersionsIterable.this.client.getSlotTypeVersions((GetSlotTypeVersionsRequest)((Object)GetSlotTypeVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

