/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.services.lakeformation.model.StorageOptimizer;
import software.amazon.awssdk.services.lakeformation.model.StorageOptimizerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTableStorageOptimizersResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, ListTableStorageOptimizersResponse> {
    private static final SdkField<List<StorageOptimizer>> STORAGE_OPTIMIZER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StorageOptimizerList").getter(ListTableStorageOptimizersResponse.getter(ListTableStorageOptimizersResponse::storageOptimizerList)).setter(ListTableStorageOptimizersResponse.setter(Builder::storageOptimizerList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageOptimizerList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorageOptimizer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTableStorageOptimizersResponse.getter(ListTableStorageOptimizersResponse::nextToken)).setter(ListTableStorageOptimizersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_OPTIMIZER_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StorageOptimizerList", STORAGE_OPTIMIZER_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<StorageOptimizer> storageOptimizerList;
    private final String nextToken;

    private ListTableStorageOptimizersResponse(BuilderImpl builder) {
        super(builder);
        this.storageOptimizerList = builder.storageOptimizerList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStorageOptimizerList() {
        return this.storageOptimizerList != null && !(this.storageOptimizerList instanceof SdkAutoConstructList);
    }

    public final List<StorageOptimizer> storageOptimizerList() {
        return this.storageOptimizerList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageOptimizerList() ? this.storageOptimizerList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableStorageOptimizersResponse)) {
            return false;
        }
        ListTableStorageOptimizersResponse other = (ListTableStorageOptimizersResponse)((Object)obj);
        return this.hasStorageOptimizerList() == other.hasStorageOptimizerList() && Objects.equals(this.storageOptimizerList(), other.storageOptimizerList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTableStorageOptimizersResponse").add("StorageOptimizerList", this.hasStorageOptimizerList() ? this.storageOptimizerList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageOptimizerList": {
                return Optional.ofNullable(clazz.cast(this.storageOptimizerList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTableStorageOptimizersResponse, T> g) {
        return obj -> g.apply((ListTableStorageOptimizersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private List<StorageOptimizer> storageOptimizerList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableStorageOptimizersResponse model) {
            super(model);
            this.storageOptimizerList(model.storageOptimizerList);
            this.nextToken(model.nextToken);
        }

        public final List<StorageOptimizer.Builder> getStorageOptimizerList() {
            List<StorageOptimizer.Builder> result = StorageOptimizerListCopier.copyToBuilder(this.storageOptimizerList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageOptimizerList(Collection<StorageOptimizer.BuilderImpl> storageOptimizerList) {
            this.storageOptimizerList = StorageOptimizerListCopier.copyFromBuilder(storageOptimizerList);
        }

        @Override
        public final Builder storageOptimizerList(Collection<StorageOptimizer> storageOptimizerList) {
            this.storageOptimizerList = StorageOptimizerListCopier.copy(storageOptimizerList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageOptimizerList(StorageOptimizer ... storageOptimizerList) {
            this.storageOptimizerList(Arrays.asList(storageOptimizerList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageOptimizerList(Consumer<StorageOptimizer.Builder> ... storageOptimizerList) {
            this.storageOptimizerList(Stream.of(storageOptimizerList).map(c -> (StorageOptimizer)((StorageOptimizer.Builder)StorageOptimizer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTableStorageOptimizersResponse build() {
            return new ListTableStorageOptimizersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTableStorageOptimizersResponse> {
        public Builder storageOptimizerList(Collection<StorageOptimizer> var1);

        public Builder storageOptimizerList(StorageOptimizer ... var1);

        public Builder storageOptimizerList(Consumer<StorageOptimizer.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

