/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSource;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SourceSchema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferenceDataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReferenceDataSource> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(ReferenceDataSource.getter(ReferenceDataSource::tableName)).setter(ReferenceDataSource.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<S3ReferenceDataSource> S3_REFERENCE_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3ReferenceDataSource").getter(ReferenceDataSource.getter(ReferenceDataSource::s3ReferenceDataSource)).setter(ReferenceDataSource.setter(Builder::s3ReferenceDataSource)).constructor(S3ReferenceDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ReferenceDataSource").build()}).build();
    private static final SdkField<SourceSchema> REFERENCE_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReferenceSchema").getter(ReferenceDataSource.getter(ReferenceDataSource::referenceSchema)).setter(ReferenceDataSource.setter(Builder::referenceSchema)).constructor(SourceSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceSchema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, S3_REFERENCE_DATA_SOURCE_FIELD, REFERENCE_SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TableName", TABLE_NAME_FIELD);
            this.put("S3ReferenceDataSource", S3_REFERENCE_DATA_SOURCE_FIELD);
            this.put("ReferenceSchema", REFERENCE_SCHEMA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final S3ReferenceDataSource s3ReferenceDataSource;
    private final SourceSchema referenceSchema;

    private ReferenceDataSource(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.s3ReferenceDataSource = builder.s3ReferenceDataSource;
        this.referenceSchema = builder.referenceSchema;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final S3ReferenceDataSource s3ReferenceDataSource() {
        return this.s3ReferenceDataSource;
    }

    public final SourceSchema referenceSchema() {
        return this.referenceSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ReferenceDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceSchema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSource)) {
            return false;
        }
        ReferenceDataSource other = (ReferenceDataSource)obj;
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.s3ReferenceDataSource(), other.s3ReferenceDataSource()) && Objects.equals(this.referenceSchema(), other.referenceSchema());
    }

    public final String toString() {
        return ToString.builder((String)"ReferenceDataSource").add("TableName", (Object)this.tableName()).add("S3ReferenceDataSource", (Object)this.s3ReferenceDataSource()).add("ReferenceSchema", (Object)this.referenceSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "S3ReferenceDataSource": {
                return Optional.ofNullable(clazz.cast(this.s3ReferenceDataSource()));
            }
            case "ReferenceSchema": {
                return Optional.ofNullable(clazz.cast(this.referenceSchema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceDataSource, T> g) {
        return obj -> g.apply((ReferenceDataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private S3ReferenceDataSource s3ReferenceDataSource;
        private SourceSchema referenceSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSource model) {
            this.tableName(model.tableName);
            this.s3ReferenceDataSource(model.s3ReferenceDataSource);
            this.referenceSchema(model.referenceSchema);
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final S3ReferenceDataSource.Builder getS3ReferenceDataSource() {
            return this.s3ReferenceDataSource != null ? this.s3ReferenceDataSource.toBuilder() : null;
        }

        public final void setS3ReferenceDataSource(S3ReferenceDataSource.BuilderImpl s3ReferenceDataSource) {
            this.s3ReferenceDataSource = s3ReferenceDataSource != null ? s3ReferenceDataSource.build() : null;
        }

        @Override
        public final Builder s3ReferenceDataSource(S3ReferenceDataSource s3ReferenceDataSource) {
            this.s3ReferenceDataSource = s3ReferenceDataSource;
            return this;
        }

        public final SourceSchema.Builder getReferenceSchema() {
            return this.referenceSchema != null ? this.referenceSchema.toBuilder() : null;
        }

        public final void setReferenceSchema(SourceSchema.BuilderImpl referenceSchema) {
            this.referenceSchema = referenceSchema != null ? referenceSchema.build() : null;
        }

        @Override
        public final Builder referenceSchema(SourceSchema referenceSchema) {
            this.referenceSchema = referenceSchema;
            return this;
        }

        public ReferenceDataSource build() {
            return new ReferenceDataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReferenceDataSource> {
        public Builder tableName(String var1);

        public Builder s3ReferenceDataSource(S3ReferenceDataSource var1);

        default public Builder s3ReferenceDataSource(Consumer<S3ReferenceDataSource.Builder> s3ReferenceDataSource) {
            return this.s3ReferenceDataSource((S3ReferenceDataSource)((S3ReferenceDataSource.Builder)S3ReferenceDataSource.builder().applyMutation(s3ReferenceDataSource)).build());
        }

        public Builder referenceSchema(SourceSchema var1);

        default public Builder referenceSchema(Consumer<SourceSchema.Builder> referenceSchema) {
            return this.referenceSchema((SourceSchema)((SourceSchema.Builder)SourceSchema.builder().applyMutation(referenceSchema)).build());
        }
    }
}

