/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.keyspaces.model.FieldDefinition;
import software.amazon.awssdk.services.keyspaces.model.FieldListCopier;
import software.amazon.awssdk.services.keyspaces.model.KeyspacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTypeRequest
extends KeyspacesRequest
implements ToCopyableBuilder<Builder, CreateTypeRequest> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyspaceName").getter(CreateTypeRequest.getter(CreateTypeRequest::keyspaceName)).setter(CreateTypeRequest.setter(Builder::keyspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeName").getter(CreateTypeRequest.getter(CreateTypeRequest::typeName)).setter(CreateTypeRequest.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeName").build()}).build();
    private static final SdkField<List<FieldDefinition>> FIELD_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fieldDefinitions").getter(CreateTypeRequest.getter(CreateTypeRequest::fieldDefinitions)).setter(CreateTypeRequest.setter(Builder::fieldDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD, TYPE_NAME_FIELD, FIELD_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("keyspaceName", KEYSPACE_NAME_FIELD);
            this.put("typeName", TYPE_NAME_FIELD);
            this.put("fieldDefinitions", FIELD_DEFINITIONS_FIELD);
        }
    });
    private final String keyspaceName;
    private final String typeName;
    private final List<FieldDefinition> fieldDefinitions;

    private CreateTypeRequest(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.typeName = builder.typeName;
        this.fieldDefinitions = builder.fieldDefinitions;
    }

    public final String keyspaceName() {
        return this.keyspaceName;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final boolean hasFieldDefinitions() {
        return this.fieldDefinitions != null && !(this.fieldDefinitions instanceof SdkAutoConstructList);
    }

    public final List<FieldDefinition> fieldDefinitions() {
        return this.fieldDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldDefinitions() ? this.fieldDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTypeRequest)) {
            return false;
        }
        CreateTypeRequest other = (CreateTypeRequest)((Object)obj);
        return Objects.equals(this.keyspaceName(), other.keyspaceName()) && Objects.equals(this.typeName(), other.typeName()) && this.hasFieldDefinitions() == other.hasFieldDefinitions() && Objects.equals(this.fieldDefinitions(), other.fieldDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTypeRequest").add("KeyspaceName", (Object)this.keyspaceName()).add("TypeName", (Object)this.typeName()).add("FieldDefinitions", this.hasFieldDefinitions() ? this.fieldDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyspaceName": {
                return Optional.ofNullable(clazz.cast(this.keyspaceName()));
            }
            case "typeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "fieldDefinitions": {
                return Optional.ofNullable(clazz.cast(this.fieldDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateTypeRequest, T> g) {
        return obj -> g.apply((CreateTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesRequest.BuilderImpl
    implements Builder {
        private String keyspaceName;
        private String typeName;
        private List<FieldDefinition> fieldDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTypeRequest model) {
            super(model);
            this.keyspaceName(model.keyspaceName);
            this.typeName(model.typeName);
            this.fieldDefinitions(model.fieldDefinitions);
        }

        public final String getKeyspaceName() {
            return this.keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final List<FieldDefinition.Builder> getFieldDefinitions() {
            List<FieldDefinition.Builder> result = FieldListCopier.copyToBuilder(this.fieldDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldDefinitions(Collection<FieldDefinition.BuilderImpl> fieldDefinitions) {
            this.fieldDefinitions = FieldListCopier.copyFromBuilder(fieldDefinitions);
        }

        @Override
        public final Builder fieldDefinitions(Collection<FieldDefinition> fieldDefinitions) {
            this.fieldDefinitions = FieldListCopier.copy(fieldDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldDefinitions(FieldDefinition ... fieldDefinitions) {
            this.fieldDefinitions(Arrays.asList(fieldDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldDefinitions(Consumer<FieldDefinition.Builder> ... fieldDefinitions) {
            this.fieldDefinitions(Stream.of(fieldDefinitions).map(c -> (FieldDefinition)((FieldDefinition.Builder)FieldDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTypeRequest build() {
            return new CreateTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KeyspacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTypeRequest> {
        public Builder keyspaceName(String var1);

        public Builder typeName(String var1);

        public Builder fieldDefinitions(Collection<FieldDefinition> var1);

        public Builder fieldDefinitions(FieldDefinition ... var1);

        public Builder fieldDefinitions(Consumer<FieldDefinition.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

