/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Search
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Search> {
    private static final SdkField<Boolean> FACETABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Facetable").getter(Search.getter(Search::facetable)).setter(Search.setter(Builder::facetable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Facetable").build()}).build();
    private static final SdkField<Boolean> SEARCHABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Searchable").getter(Search.getter(Search::searchable)).setter(Search.setter(Builder::searchable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Searchable").build()}).build();
    private static final SdkField<Boolean> DISPLAYABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Displayable").getter(Search.getter(Search::displayable)).setter(Search.setter(Builder::displayable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Displayable").build()}).build();
    private static final SdkField<Boolean> SORTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Sortable").getter(Search.getter(Search::sortable)).setter(Search.setter(Builder::sortable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sortable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACETABLE_FIELD, SEARCHABLE_FIELD, DISPLAYABLE_FIELD, SORTABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Facetable", FACETABLE_FIELD);
            this.put("Searchable", SEARCHABLE_FIELD);
            this.put("Displayable", DISPLAYABLE_FIELD);
            this.put("Sortable", SORTABLE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean facetable;
    private final Boolean searchable;
    private final Boolean displayable;
    private final Boolean sortable;

    private Search(BuilderImpl builder) {
        this.facetable = builder.facetable;
        this.searchable = builder.searchable;
        this.displayable = builder.displayable;
        this.sortable = builder.sortable;
    }

    public final Boolean facetable() {
        return this.facetable;
    }

    public final Boolean searchable() {
        return this.searchable;
    }

    public final Boolean displayable() {
        return this.displayable;
    }

    public final Boolean sortable() {
        return this.sortable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.facetable());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchable());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayable());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Search)) {
            return false;
        }
        Search other = (Search)obj;
        return Objects.equals(this.facetable(), other.facetable()) && Objects.equals(this.searchable(), other.searchable()) && Objects.equals(this.displayable(), other.displayable()) && Objects.equals(this.sortable(), other.sortable());
    }

    public final String toString() {
        return ToString.builder((String)"Search").add("Facetable", (Object)this.facetable()).add("Searchable", (Object)this.searchable()).add("Displayable", (Object)this.displayable()).add("Sortable", (Object)this.sortable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Facetable": {
                return Optional.ofNullable(clazz.cast(this.facetable()));
            }
            case "Searchable": {
                return Optional.ofNullable(clazz.cast(this.searchable()));
            }
            case "Displayable": {
                return Optional.ofNullable(clazz.cast(this.displayable()));
            }
            case "Sortable": {
                return Optional.ofNullable(clazz.cast(this.sortable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Search, T> g) {
        return obj -> g.apply((Search)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean facetable;
        private Boolean searchable;
        private Boolean displayable;
        private Boolean sortable;

        private BuilderImpl() {
        }

        private BuilderImpl(Search model) {
            this.facetable(model.facetable);
            this.searchable(model.searchable);
            this.displayable(model.displayable);
            this.sortable(model.sortable);
        }

        public final Boolean getFacetable() {
            return this.facetable;
        }

        public final void setFacetable(Boolean facetable) {
            this.facetable = facetable;
        }

        @Override
        public final Builder facetable(Boolean facetable) {
            this.facetable = facetable;
            return this;
        }

        public final Boolean getSearchable() {
            return this.searchable;
        }

        public final void setSearchable(Boolean searchable) {
            this.searchable = searchable;
        }

        @Override
        public final Builder searchable(Boolean searchable) {
            this.searchable = searchable;
            return this;
        }

        public final Boolean getDisplayable() {
            return this.displayable;
        }

        public final void setDisplayable(Boolean displayable) {
            this.displayable = displayable;
        }

        @Override
        public final Builder displayable(Boolean displayable) {
            this.displayable = displayable;
            return this;
        }

        public final Boolean getSortable() {
            return this.sortable;
        }

        public final void setSortable(Boolean sortable) {
            this.sortable = sortable;
        }

        @Override
        public final Builder sortable(Boolean sortable) {
            this.sortable = sortable;
            return this;
        }

        public Search build() {
            return new Search(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Search> {
        public Builder facetable(Boolean var1);

        public Builder searchable(Boolean var1);

        public Builder displayable(Boolean var1);

        public Builder sortable(Boolean var1);
    }
}

