/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DocumentAttribute;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeListCopier;
import software.amazon.awssdk.services.kendra.model.TextWithHighlights;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpandedResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpandedResultItem> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ExpandedResultItem.getter(ExpandedResultItem::id)).setter(ExpandedResultItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentId").getter(ExpandedResultItem.getter(ExpandedResultItem::documentId)).setter(ExpandedResultItem.setter(Builder::documentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()}).build();
    private static final SdkField<TextWithHighlights> DOCUMENT_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentTitle").getter(ExpandedResultItem.getter(ExpandedResultItem::documentTitle)).setter(ExpandedResultItem.setter(Builder::documentTitle)).constructor(TextWithHighlights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitle").build()}).build();
    private static final SdkField<TextWithHighlights> DOCUMENT_EXCERPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentExcerpt").getter(ExpandedResultItem.getter(ExpandedResultItem::documentExcerpt)).setter(ExpandedResultItem.setter(Builder::documentExcerpt)).constructor(TextWithHighlights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentExcerpt").build()}).build();
    private static final SdkField<String> DOCUMENT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentURI").getter(ExpandedResultItem.getter(ExpandedResultItem::documentURI)).setter(ExpandedResultItem.setter(Builder::documentURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentURI").build()}).build();
    private static final SdkField<List<DocumentAttribute>> DOCUMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentAttributes").getter(ExpandedResultItem.getter(ExpandedResultItem::documentAttributes)).setter(ExpandedResultItem.setter(Builder::documentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DOCUMENT_ID_FIELD, DOCUMENT_TITLE_FIELD, DOCUMENT_EXCERPT_FIELD, DOCUMENT_URI_FIELD, DOCUMENT_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("DocumentId", DOCUMENT_ID_FIELD);
            this.put("DocumentTitle", DOCUMENT_TITLE_FIELD);
            this.put("DocumentExcerpt", DOCUMENT_EXCERPT_FIELD);
            this.put("DocumentURI", DOCUMENT_URI_FIELD);
            this.put("DocumentAttributes", DOCUMENT_ATTRIBUTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String documentId;
    private final TextWithHighlights documentTitle;
    private final TextWithHighlights documentExcerpt;
    private final String documentURI;
    private final List<DocumentAttribute> documentAttributes;

    private ExpandedResultItem(BuilderImpl builder) {
        this.id = builder.id;
        this.documentId = builder.documentId;
        this.documentTitle = builder.documentTitle;
        this.documentExcerpt = builder.documentExcerpt;
        this.documentURI = builder.documentURI;
        this.documentAttributes = builder.documentAttributes;
    }

    public final String id() {
        return this.id;
    }

    public final String documentId() {
        return this.documentId;
    }

    public final TextWithHighlights documentTitle() {
        return this.documentTitle;
    }

    public final TextWithHighlights documentExcerpt() {
        return this.documentExcerpt;
    }

    public final String documentURI() {
        return this.documentURI;
    }

    public final boolean hasDocumentAttributes() {
        return this.documentAttributes != null && !(this.documentAttributes instanceof SdkAutoConstructList);
    }

    public final List<DocumentAttribute> documentAttributes() {
        return this.documentAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentExcerpt());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentAttributes() ? this.documentAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpandedResultItem)) {
            return false;
        }
        ExpandedResultItem other = (ExpandedResultItem)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.documentTitle(), other.documentTitle()) && Objects.equals(this.documentExcerpt(), other.documentExcerpt()) && Objects.equals(this.documentURI(), other.documentURI()) && this.hasDocumentAttributes() == other.hasDocumentAttributes() && Objects.equals(this.documentAttributes(), other.documentAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"ExpandedResultItem").add("Id", (Object)this.id()).add("DocumentId", (Object)this.documentId()).add("DocumentTitle", (Object)this.documentTitle()).add("DocumentExcerpt", (Object)this.documentExcerpt()).add("DocumentURI", (Object)this.documentURI()).add("DocumentAttributes", this.hasDocumentAttributes() ? this.documentAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "DocumentId": {
                return Optional.ofNullable(clazz.cast(this.documentId()));
            }
            case "DocumentTitle": {
                return Optional.ofNullable(clazz.cast(this.documentTitle()));
            }
            case "DocumentExcerpt": {
                return Optional.ofNullable(clazz.cast(this.documentExcerpt()));
            }
            case "DocumentURI": {
                return Optional.ofNullable(clazz.cast(this.documentURI()));
            }
            case "DocumentAttributes": {
                return Optional.ofNullable(clazz.cast(this.documentAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExpandedResultItem, T> g) {
        return obj -> g.apply((ExpandedResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String documentId;
        private TextWithHighlights documentTitle;
        private TextWithHighlights documentExcerpt;
        private String documentURI;
        private List<DocumentAttribute> documentAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExpandedResultItem model) {
            this.id(model.id);
            this.documentId(model.documentId);
            this.documentTitle(model.documentTitle);
            this.documentExcerpt(model.documentExcerpt);
            this.documentURI(model.documentURI);
            this.documentAttributes(model.documentAttributes);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final TextWithHighlights.Builder getDocumentTitle() {
            return this.documentTitle != null ? this.documentTitle.toBuilder() : null;
        }

        public final void setDocumentTitle(TextWithHighlights.BuilderImpl documentTitle) {
            this.documentTitle = documentTitle != null ? documentTitle.build() : null;
        }

        @Override
        public final Builder documentTitle(TextWithHighlights documentTitle) {
            this.documentTitle = documentTitle;
            return this;
        }

        public final TextWithHighlights.Builder getDocumentExcerpt() {
            return this.documentExcerpt != null ? this.documentExcerpt.toBuilder() : null;
        }

        public final void setDocumentExcerpt(TextWithHighlights.BuilderImpl documentExcerpt) {
            this.documentExcerpt = documentExcerpt != null ? documentExcerpt.build() : null;
        }

        @Override
        public final Builder documentExcerpt(TextWithHighlights documentExcerpt) {
            this.documentExcerpt = documentExcerpt;
            return this;
        }

        public final String getDocumentURI() {
            return this.documentURI;
        }

        public final void setDocumentURI(String documentURI) {
            this.documentURI = documentURI;
        }

        @Override
        public final Builder documentURI(String documentURI) {
            this.documentURI = documentURI;
            return this;
        }

        public final List<DocumentAttribute.Builder> getDocumentAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributeListCopier.copyToBuilder(this.documentAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentAttributes(Collection<DocumentAttribute.BuilderImpl> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copyFromBuilder(documentAttributes);
        }

        @Override
        public final Builder documentAttributes(Collection<DocumentAttribute> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copy(documentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(DocumentAttribute ... documentAttributes) {
            this.documentAttributes(Arrays.asList(documentAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(Consumer<DocumentAttribute.Builder> ... documentAttributes) {
            this.documentAttributes(Stream.of(documentAttributes).map(c -> (DocumentAttribute)((DocumentAttribute.Builder)DocumentAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ExpandedResultItem build() {
            return new ExpandedResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpandedResultItem> {
        public Builder id(String var1);

        public Builder documentId(String var1);

        public Builder documentTitle(TextWithHighlights var1);

        default public Builder documentTitle(Consumer<TextWithHighlights.Builder> documentTitle) {
            return this.documentTitle((TextWithHighlights)((TextWithHighlights.Builder)TextWithHighlights.builder().applyMutation(documentTitle)).build());
        }

        public Builder documentExcerpt(TextWithHighlights var1);

        default public Builder documentExcerpt(Consumer<TextWithHighlights.Builder> documentExcerpt) {
            return this.documentExcerpt((TextWithHighlights)((TextWithHighlights.Builder)TextWithHighlights.builder().applyMutation(documentExcerpt)).build());
        }

        public Builder documentURI(String var1);

        public Builder documentAttributes(Collection<DocumentAttribute> var1);

        public Builder documentAttributes(DocumentAttribute ... var1);

        public Builder documentAttributes(Consumer<DocumentAttribute.Builder> ... var1);
    }
}

