/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.IngestConfigurationSummary;
import software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsResponse;

public class ListIngestConfigurationsIterable
implements SdkIterable<ListIngestConfigurationsResponse> {
    private final IvsRealTimeClient client;
    private final ListIngestConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIngestConfigurationsIterable(IvsRealTimeClient client, ListIngestConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIngestConfigurationsResponseFetcher();
    }

    public Iterator<ListIngestConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IngestConfigurationSummary> ingestConfigurations() {
        Function<ListIngestConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ingestConfigurations() != null) {
                return response.ingestConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIngestConfigurationsResponseFetcher
    implements SyncPageFetcher<ListIngestConfigurationsResponse> {
        private ListIngestConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListIngestConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIngestConfigurationsResponse nextPage(ListIngestConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListIngestConfigurationsIterable.this.client.listIngestConfigurations(ListIngestConfigurationsIterable.this.firstRequest);
            }
            return ListIngestConfigurationsIterable.this.client.listIngestConfigurations((ListIngestConfigurationsRequest)((Object)ListIngestConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

