/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivsrealtime.model.IngestProtocol;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantAttributesCopier;
import software.amazon.awssdk.services.ivsrealtime.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIngestConfigurationRequest
extends IvsRealTimeRequest
implements ToCopyableBuilder<Builder, CreateIngestConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateIngestConfigurationRequest.getter(CreateIngestConfigurationRequest::name)).setter(CreateIngestConfigurationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stageArn").getter(CreateIngestConfigurationRequest.getter(CreateIngestConfigurationRequest::stageArn)).setter(CreateIngestConfigurationRequest.setter(Builder::stageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(CreateIngestConfigurationRequest.getter(CreateIngestConfigurationRequest::userId)).setter(CreateIngestConfigurationRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(CreateIngestConfigurationRequest.getter(CreateIngestConfigurationRequest::attributes)).setter(CreateIngestConfigurationRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> INGEST_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestProtocol").getter(CreateIngestConfigurationRequest.getter(CreateIngestConfigurationRequest::ingestProtocolAsString)).setter(CreateIngestConfigurationRequest.setter(Builder::ingestProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestProtocol").build()}).build();
    private static final SdkField<Boolean> INSECURE_INGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("insecureIngest").getter(CreateIngestConfigurationRequest.getter(CreateIngestConfigurationRequest::insecureIngest)).setter(CreateIngestConfigurationRequest.setter(Builder::insecureIngest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insecureIngest").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateIngestConfigurationRequest.getter(CreateIngestConfigurationRequest::tags)).setter(CreateIngestConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STAGE_ARN_FIELD, USER_ID_FIELD, ATTRIBUTES_FIELD, INGEST_PROTOCOL_FIELD, INSECURE_INGEST_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("stageArn", STAGE_ARN_FIELD);
            this.put("userId", USER_ID_FIELD);
            this.put("attributes", ATTRIBUTES_FIELD);
            this.put("ingestProtocol", INGEST_PROTOCOL_FIELD);
            this.put("insecureIngest", INSECURE_INGEST_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String name;
    private final String stageArn;
    private final String userId;
    private final Map<String, String> attributes;
    private final String ingestProtocol;
    private final Boolean insecureIngest;
    private final Map<String, String> tags;

    private CreateIngestConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.stageArn = builder.stageArn;
        this.userId = builder.userId;
        this.attributes = builder.attributes;
        this.ingestProtocol = builder.ingestProtocol;
        this.insecureIngest = builder.insecureIngest;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String stageArn() {
        return this.stageArn;
    }

    public final String userId() {
        return this.userId;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final IngestProtocol ingestProtocol() {
        return IngestProtocol.fromValue(this.ingestProtocol);
    }

    public final String ingestProtocolAsString() {
        return this.ingestProtocol;
    }

    public final Boolean insecureIngest() {
        return this.insecureIngest;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.insecureIngest());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIngestConfigurationRequest)) {
            return false;
        }
        CreateIngestConfigurationRequest other = (CreateIngestConfigurationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.stageArn(), other.stageArn()) && Objects.equals(this.userId(), other.userId()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.ingestProtocolAsString(), other.ingestProtocolAsString()) && Objects.equals(this.insecureIngest(), other.insecureIngest()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIngestConfigurationRequest").add("Name", (Object)this.name()).add("StageArn", (Object)this.stageArn()).add("UserId", (Object)this.userId()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("IngestProtocol", (Object)this.ingestProtocolAsString()).add("InsecureIngest", (Object)this.insecureIngest()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "stageArn": {
                return Optional.ofNullable(clazz.cast(this.stageArn()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "ingestProtocol": {
                return Optional.ofNullable(clazz.cast(this.ingestProtocolAsString()));
            }
            case "insecureIngest": {
                return Optional.ofNullable(clazz.cast(this.insecureIngest()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateIngestConfigurationRequest, T> g) {
        return obj -> g.apply((CreateIngestConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeRequest.BuilderImpl
    implements Builder {
        private String name;
        private String stageArn;
        private String userId;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String ingestProtocol;
        private Boolean insecureIngest;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIngestConfigurationRequest model) {
            super(model);
            this.name(model.name);
            this.stageArn(model.stageArn);
            this.userId(model.userId);
            this.attributes(model.attributes);
            this.ingestProtocol(model.ingestProtocol);
            this.insecureIngest(model.insecureIngest);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStageArn() {
            return this.stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
            return this;
        }

        public final String getIngestProtocol() {
            return this.ingestProtocol;
        }

        public final void setIngestProtocol(String ingestProtocol) {
            this.ingestProtocol = ingestProtocol;
        }

        @Override
        public final Builder ingestProtocol(String ingestProtocol) {
            this.ingestProtocol = ingestProtocol;
            return this;
        }

        @Override
        public final Builder ingestProtocol(IngestProtocol ingestProtocol) {
            this.ingestProtocol(ingestProtocol == null ? null : ingestProtocol.toString());
            return this;
        }

        public final Boolean getInsecureIngest() {
            return this.insecureIngest;
        }

        public final void setInsecureIngest(Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
        }

        @Override
        public final Builder insecureIngest(Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIngestConfigurationRequest build() {
            return new CreateIngestConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IvsRealTimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIngestConfigurationRequest> {
        public Builder name(String var1);

        public Builder stageArn(String var1);

        public Builder userId(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder ingestProtocol(String var1);

        public Builder ingestProtocol(IngestProtocol var1);

        public Builder insecureIngest(Boolean var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

