/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessClient;
import software.amazon.awssdk.services.iotwireless.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse;

public class ListServiceProfilesIterable
implements SdkIterable<ListServiceProfilesResponse> {
    private final IotWirelessClient client;
    private final ListServiceProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceProfilesIterable(IotWirelessClient client, ListServiceProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceProfilesResponseFetcher();
    }

    public Iterator<ListServiceProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListServiceProfilesResponseFetcher
    implements SyncPageFetcher<ListServiceProfilesResponse> {
        private ListServiceProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceProfilesResponse nextPage(ListServiceProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceProfilesIterable.this.client.listServiceProfiles(ListServiceProfilesIterable.this.firstRequest);
            }
            return ListServiceProfilesIterable.this.client.listServiceProfiles((ListServiceProfilesRequest)((Object)ListServiceProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

