/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.WcdmaLocalId;
import software.amazon.awssdk.services.iotwireless.model.WcdmaNmrListCopier;
import software.amazon.awssdk.services.iotwireless.model.WcdmaNmrObj;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WcdmaObj
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WcdmaObj> {
    private static final SdkField<Integer> MCC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Mcc").getter(WcdmaObj.getter(WcdmaObj::mcc)).setter(WcdmaObj.setter(Builder::mcc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mcc").build()}).build();
    private static final SdkField<Integer> MNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Mnc").getter(WcdmaObj.getter(WcdmaObj::mnc)).setter(WcdmaObj.setter(Builder::mnc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mnc").build()}).build();
    private static final SdkField<Integer> LAC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Lac").getter(WcdmaObj.getter(WcdmaObj::lac)).setter(WcdmaObj.setter(Builder::lac)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lac").build()}).build();
    private static final SdkField<Integer> UTRAN_CID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UtranCid").getter(WcdmaObj.getter(WcdmaObj::utranCid)).setter(WcdmaObj.setter(Builder::utranCid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtranCid").build()}).build();
    private static final SdkField<WcdmaLocalId> WCDMA_LOCAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WcdmaLocalId").getter(WcdmaObj.getter(WcdmaObj::wcdmaLocalId)).setter(WcdmaObj.setter(Builder::wcdmaLocalId)).constructor(WcdmaLocalId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WcdmaLocalId").build()}).build();
    private static final SdkField<Integer> RSCP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Rscp").getter(WcdmaObj.getter(WcdmaObj::rscp)).setter(WcdmaObj.setter(Builder::rscp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rscp").build()}).build();
    private static final SdkField<Integer> PATH_LOSS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PathLoss").getter(WcdmaObj.getter(WcdmaObj::pathLoss)).setter(WcdmaObj.setter(Builder::pathLoss)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathLoss").build()}).build();
    private static final SdkField<List<WcdmaNmrObj>> WCDMA_NMR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WcdmaNmr").getter(WcdmaObj.getter(WcdmaObj::wcdmaNmr)).setter(WcdmaObj.setter(Builder::wcdmaNmr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WcdmaNmr").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WcdmaNmrObj::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MCC_FIELD, MNC_FIELD, LAC_FIELD, UTRAN_CID_FIELD, WCDMA_LOCAL_ID_FIELD, RSCP_FIELD, PATH_LOSS_FIELD, WCDMA_NMR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Mcc", MCC_FIELD);
            this.put("Mnc", MNC_FIELD);
            this.put("Lac", LAC_FIELD);
            this.put("UtranCid", UTRAN_CID_FIELD);
            this.put("WcdmaLocalId", WCDMA_LOCAL_ID_FIELD);
            this.put("Rscp", RSCP_FIELD);
            this.put("PathLoss", PATH_LOSS_FIELD);
            this.put("WcdmaNmr", WCDMA_NMR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer mcc;
    private final Integer mnc;
    private final Integer lac;
    private final Integer utranCid;
    private final WcdmaLocalId wcdmaLocalId;
    private final Integer rscp;
    private final Integer pathLoss;
    private final List<WcdmaNmrObj> wcdmaNmr;

    private WcdmaObj(BuilderImpl builder) {
        this.mcc = builder.mcc;
        this.mnc = builder.mnc;
        this.lac = builder.lac;
        this.utranCid = builder.utranCid;
        this.wcdmaLocalId = builder.wcdmaLocalId;
        this.rscp = builder.rscp;
        this.pathLoss = builder.pathLoss;
        this.wcdmaNmr = builder.wcdmaNmr;
    }

    public final Integer mcc() {
        return this.mcc;
    }

    public final Integer mnc() {
        return this.mnc;
    }

    public final Integer lac() {
        return this.lac;
    }

    public final Integer utranCid() {
        return this.utranCid;
    }

    public final WcdmaLocalId wcdmaLocalId() {
        return this.wcdmaLocalId;
    }

    public final Integer rscp() {
        return this.rscp;
    }

    public final Integer pathLoss() {
        return this.pathLoss;
    }

    public final boolean hasWcdmaNmr() {
        return this.wcdmaNmr != null && !(this.wcdmaNmr instanceof SdkAutoConstructList);
    }

    public final List<WcdmaNmrObj> wcdmaNmr() {
        return this.wcdmaNmr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mcc());
        hashCode = 31 * hashCode + Objects.hashCode(this.mnc());
        hashCode = 31 * hashCode + Objects.hashCode(this.lac());
        hashCode = 31 * hashCode + Objects.hashCode(this.utranCid());
        hashCode = 31 * hashCode + Objects.hashCode(this.wcdmaLocalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rscp());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathLoss());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWcdmaNmr() ? this.wcdmaNmr() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WcdmaObj)) {
            return false;
        }
        WcdmaObj other = (WcdmaObj)obj;
        return Objects.equals(this.mcc(), other.mcc()) && Objects.equals(this.mnc(), other.mnc()) && Objects.equals(this.lac(), other.lac()) && Objects.equals(this.utranCid(), other.utranCid()) && Objects.equals(this.wcdmaLocalId(), other.wcdmaLocalId()) && Objects.equals(this.rscp(), other.rscp()) && Objects.equals(this.pathLoss(), other.pathLoss()) && this.hasWcdmaNmr() == other.hasWcdmaNmr() && Objects.equals(this.wcdmaNmr(), other.wcdmaNmr());
    }

    public final String toString() {
        return ToString.builder((String)"WcdmaObj").add("Mcc", (Object)this.mcc()).add("Mnc", (Object)this.mnc()).add("Lac", (Object)this.lac()).add("UtranCid", (Object)this.utranCid()).add("WcdmaLocalId", (Object)this.wcdmaLocalId()).add("Rscp", (Object)this.rscp()).add("PathLoss", (Object)this.pathLoss()).add("WcdmaNmr", this.hasWcdmaNmr() ? this.wcdmaNmr() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mcc": {
                return Optional.ofNullable(clazz.cast(this.mcc()));
            }
            case "Mnc": {
                return Optional.ofNullable(clazz.cast(this.mnc()));
            }
            case "Lac": {
                return Optional.ofNullable(clazz.cast(this.lac()));
            }
            case "UtranCid": {
                return Optional.ofNullable(clazz.cast(this.utranCid()));
            }
            case "WcdmaLocalId": {
                return Optional.ofNullable(clazz.cast(this.wcdmaLocalId()));
            }
            case "Rscp": {
                return Optional.ofNullable(clazz.cast(this.rscp()));
            }
            case "PathLoss": {
                return Optional.ofNullable(clazz.cast(this.pathLoss()));
            }
            case "WcdmaNmr": {
                return Optional.ofNullable(clazz.cast(this.wcdmaNmr()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WcdmaObj, T> g) {
        return obj -> g.apply((WcdmaObj)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer mcc;
        private Integer mnc;
        private Integer lac;
        private Integer utranCid;
        private WcdmaLocalId wcdmaLocalId;
        private Integer rscp;
        private Integer pathLoss;
        private List<WcdmaNmrObj> wcdmaNmr = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WcdmaObj model) {
            this.mcc(model.mcc);
            this.mnc(model.mnc);
            this.lac(model.lac);
            this.utranCid(model.utranCid);
            this.wcdmaLocalId(model.wcdmaLocalId);
            this.rscp(model.rscp);
            this.pathLoss(model.pathLoss);
            this.wcdmaNmr(model.wcdmaNmr);
        }

        public final Integer getMcc() {
            return this.mcc;
        }

        public final void setMcc(Integer mcc) {
            this.mcc = mcc;
        }

        @Override
        public final Builder mcc(Integer mcc) {
            this.mcc = mcc;
            return this;
        }

        public final Integer getMnc() {
            return this.mnc;
        }

        public final void setMnc(Integer mnc) {
            this.mnc = mnc;
        }

        @Override
        public final Builder mnc(Integer mnc) {
            this.mnc = mnc;
            return this;
        }

        public final Integer getLac() {
            return this.lac;
        }

        public final void setLac(Integer lac) {
            this.lac = lac;
        }

        @Override
        public final Builder lac(Integer lac) {
            this.lac = lac;
            return this;
        }

        public final Integer getUtranCid() {
            return this.utranCid;
        }

        public final void setUtranCid(Integer utranCid) {
            this.utranCid = utranCid;
        }

        @Override
        public final Builder utranCid(Integer utranCid) {
            this.utranCid = utranCid;
            return this;
        }

        public final WcdmaLocalId.Builder getWcdmaLocalId() {
            return this.wcdmaLocalId != null ? this.wcdmaLocalId.toBuilder() : null;
        }

        public final void setWcdmaLocalId(WcdmaLocalId.BuilderImpl wcdmaLocalId) {
            this.wcdmaLocalId = wcdmaLocalId != null ? wcdmaLocalId.build() : null;
        }

        @Override
        public final Builder wcdmaLocalId(WcdmaLocalId wcdmaLocalId) {
            this.wcdmaLocalId = wcdmaLocalId;
            return this;
        }

        public final Integer getRscp() {
            return this.rscp;
        }

        public final void setRscp(Integer rscp) {
            this.rscp = rscp;
        }

        @Override
        public final Builder rscp(Integer rscp) {
            this.rscp = rscp;
            return this;
        }

        public final Integer getPathLoss() {
            return this.pathLoss;
        }

        public final void setPathLoss(Integer pathLoss) {
            this.pathLoss = pathLoss;
        }

        @Override
        public final Builder pathLoss(Integer pathLoss) {
            this.pathLoss = pathLoss;
            return this;
        }

        public final List<WcdmaNmrObj.Builder> getWcdmaNmr() {
            List<WcdmaNmrObj.Builder> result = WcdmaNmrListCopier.copyToBuilder(this.wcdmaNmr);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWcdmaNmr(Collection<WcdmaNmrObj.BuilderImpl> wcdmaNmr) {
            this.wcdmaNmr = WcdmaNmrListCopier.copyFromBuilder(wcdmaNmr);
        }

        @Override
        public final Builder wcdmaNmr(Collection<WcdmaNmrObj> wcdmaNmr) {
            this.wcdmaNmr = WcdmaNmrListCopier.copy(wcdmaNmr);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wcdmaNmr(WcdmaNmrObj ... wcdmaNmr) {
            this.wcdmaNmr(Arrays.asList(wcdmaNmr));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wcdmaNmr(Consumer<WcdmaNmrObj.Builder> ... wcdmaNmr) {
            this.wcdmaNmr(Stream.of(wcdmaNmr).map(c -> (WcdmaNmrObj)((WcdmaNmrObj.Builder)WcdmaNmrObj.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public WcdmaObj build() {
            return new WcdmaObj(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WcdmaObj> {
        public Builder mcc(Integer var1);

        public Builder mnc(Integer var1);

        public Builder lac(Integer var1);

        public Builder utranCid(Integer var1);

        public Builder wcdmaLocalId(WcdmaLocalId var1);

        default public Builder wcdmaLocalId(Consumer<WcdmaLocalId.Builder> wcdmaLocalId) {
            return this.wcdmaLocalId((WcdmaLocalId)((WcdmaLocalId.Builder)WcdmaLocalId.builder().applyMutation(wcdmaLocalId)).build());
        }

        public Builder rscp(Integer var1);

        public Builder pathLoss(Integer var1);

        public Builder wcdmaNmr(Collection<WcdmaNmrObj> var1);

        public Builder wcdmaNmr(WcdmaNmrObj ... var1);

        public Builder wcdmaNmr(Consumer<WcdmaNmrObj.Builder> ... var1);
    }
}

