/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntriesCopier;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntriesCopier;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntriesCopier;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAssetPropertyValueHistoryResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, BatchGetAssetPropertyValueHistoryResponse> {
    private static final SdkField<List<BatchGetAssetPropertyValueHistoryErrorEntry>> ERROR_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errorEntries").getter(BatchGetAssetPropertyValueHistoryResponse.getter(BatchGetAssetPropertyValueHistoryResponse::errorEntries)).setter(BatchGetAssetPropertyValueHistoryResponse.setter(Builder::errorEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetAssetPropertyValueHistoryErrorEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetAssetPropertyValueHistorySuccessEntry>> SUCCESS_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successEntries").getter(BatchGetAssetPropertyValueHistoryResponse.getter(BatchGetAssetPropertyValueHistoryResponse::successEntries)).setter(BatchGetAssetPropertyValueHistoryResponse.setter(Builder::successEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetAssetPropertyValueHistorySuccessEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetAssetPropertyValueHistorySkippedEntry>> SKIPPED_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("skippedEntries").getter(BatchGetAssetPropertyValueHistoryResponse.getter(BatchGetAssetPropertyValueHistoryResponse::skippedEntries)).setter(BatchGetAssetPropertyValueHistoryResponse.setter(Builder::skippedEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skippedEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetAssetPropertyValueHistorySkippedEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(BatchGetAssetPropertyValueHistoryResponse.getter(BatchGetAssetPropertyValueHistoryResponse::nextToken)).setter(BatchGetAssetPropertyValueHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_ENTRIES_FIELD, SUCCESS_ENTRIES_FIELD, SKIPPED_ENTRIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("errorEntries", ERROR_ENTRIES_FIELD);
            this.put("successEntries", SUCCESS_ENTRIES_FIELD);
            this.put("skippedEntries", SKIPPED_ENTRIES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<BatchGetAssetPropertyValueHistoryErrorEntry> errorEntries;
    private final List<BatchGetAssetPropertyValueHistorySuccessEntry> successEntries;
    private final List<BatchGetAssetPropertyValueHistorySkippedEntry> skippedEntries;
    private final String nextToken;

    private BatchGetAssetPropertyValueHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.errorEntries = builder.errorEntries;
        this.successEntries = builder.successEntries;
        this.skippedEntries = builder.skippedEntries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasErrorEntries() {
        return this.errorEntries != null && !(this.errorEntries instanceof SdkAutoConstructList);
    }

    public final List<BatchGetAssetPropertyValueHistoryErrorEntry> errorEntries() {
        return this.errorEntries;
    }

    public final boolean hasSuccessEntries() {
        return this.successEntries != null && !(this.successEntries instanceof SdkAutoConstructList);
    }

    public final List<BatchGetAssetPropertyValueHistorySuccessEntry> successEntries() {
        return this.successEntries;
    }

    public final boolean hasSkippedEntries() {
        return this.skippedEntries != null && !(this.skippedEntries instanceof SdkAutoConstructList);
    }

    public final List<BatchGetAssetPropertyValueHistorySkippedEntry> skippedEntries() {
        return this.skippedEntries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorEntries() ? this.errorEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessEntries() ? this.successEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSkippedEntries() ? this.skippedEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyValueHistoryResponse)) {
            return false;
        }
        BatchGetAssetPropertyValueHistoryResponse other = (BatchGetAssetPropertyValueHistoryResponse)((Object)obj);
        return this.hasErrorEntries() == other.hasErrorEntries() && Objects.equals(this.errorEntries(), other.errorEntries()) && this.hasSuccessEntries() == other.hasSuccessEntries() && Objects.equals(this.successEntries(), other.successEntries()) && this.hasSkippedEntries() == other.hasSkippedEntries() && Objects.equals(this.skippedEntries(), other.skippedEntries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAssetPropertyValueHistoryResponse").add("ErrorEntries", this.hasErrorEntries() ? this.errorEntries() : null).add("SuccessEntries", this.hasSuccessEntries() ? this.successEntries() : null).add("SkippedEntries", this.hasSkippedEntries() ? this.skippedEntries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorEntries": {
                return Optional.ofNullable(clazz.cast(this.errorEntries()));
            }
            case "successEntries": {
                return Optional.ofNullable(clazz.cast(this.successEntries()));
            }
            case "skippedEntries": {
                return Optional.ofNullable(clazz.cast(this.skippedEntries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyValueHistoryResponse, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyValueHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<BatchGetAssetPropertyValueHistoryErrorEntry> errorEntries = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetAssetPropertyValueHistorySuccessEntry> successEntries = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetAssetPropertyValueHistorySkippedEntry> skippedEntries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyValueHistoryResponse model) {
            super(model);
            this.errorEntries(model.errorEntries);
            this.successEntries(model.successEntries);
            this.skippedEntries(model.skippedEntries);
            this.nextToken(model.nextToken);
        }

        public final List<BatchGetAssetPropertyValueHistoryErrorEntry.Builder> getErrorEntries() {
            List<BatchGetAssetPropertyValueHistoryErrorEntry.Builder> result = BatchGetAssetPropertyValueHistoryErrorEntriesCopier.copyToBuilder(this.errorEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorEntries(Collection<BatchGetAssetPropertyValueHistoryErrorEntry.BuilderImpl> errorEntries) {
            this.errorEntries = BatchGetAssetPropertyValueHistoryErrorEntriesCopier.copyFromBuilder(errorEntries);
        }

        @Override
        public final Builder errorEntries(Collection<BatchGetAssetPropertyValueHistoryErrorEntry> errorEntries) {
            this.errorEntries = BatchGetAssetPropertyValueHistoryErrorEntriesCopier.copy(errorEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(BatchGetAssetPropertyValueHistoryErrorEntry ... errorEntries) {
            this.errorEntries(Arrays.asList(errorEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(Consumer<BatchGetAssetPropertyValueHistoryErrorEntry.Builder> ... errorEntries) {
            this.errorEntries(Stream.of(errorEntries).map(c -> (BatchGetAssetPropertyValueHistoryErrorEntry)((BatchGetAssetPropertyValueHistoryErrorEntry.Builder)BatchGetAssetPropertyValueHistoryErrorEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetAssetPropertyValueHistorySuccessEntry.Builder> getSuccessEntries() {
            List<BatchGetAssetPropertyValueHistorySuccessEntry.Builder> result = BatchGetAssetPropertyValueHistorySuccessEntriesCopier.copyToBuilder(this.successEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessEntries(Collection<BatchGetAssetPropertyValueHistorySuccessEntry.BuilderImpl> successEntries) {
            this.successEntries = BatchGetAssetPropertyValueHistorySuccessEntriesCopier.copyFromBuilder(successEntries);
        }

        @Override
        public final Builder successEntries(Collection<BatchGetAssetPropertyValueHistorySuccessEntry> successEntries) {
            this.successEntries = BatchGetAssetPropertyValueHistorySuccessEntriesCopier.copy(successEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successEntries(BatchGetAssetPropertyValueHistorySuccessEntry ... successEntries) {
            this.successEntries(Arrays.asList(successEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successEntries(Consumer<BatchGetAssetPropertyValueHistorySuccessEntry.Builder> ... successEntries) {
            this.successEntries(Stream.of(successEntries).map(c -> (BatchGetAssetPropertyValueHistorySuccessEntry)((BatchGetAssetPropertyValueHistorySuccessEntry.Builder)BatchGetAssetPropertyValueHistorySuccessEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetAssetPropertyValueHistorySkippedEntry.Builder> getSkippedEntries() {
            List<BatchGetAssetPropertyValueHistorySkippedEntry.Builder> result = BatchGetAssetPropertyValueHistorySkippedEntriesCopier.copyToBuilder(this.skippedEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSkippedEntries(Collection<BatchGetAssetPropertyValueHistorySkippedEntry.BuilderImpl> skippedEntries) {
            this.skippedEntries = BatchGetAssetPropertyValueHistorySkippedEntriesCopier.copyFromBuilder(skippedEntries);
        }

        @Override
        public final Builder skippedEntries(Collection<BatchGetAssetPropertyValueHistorySkippedEntry> skippedEntries) {
            this.skippedEntries = BatchGetAssetPropertyValueHistorySkippedEntriesCopier.copy(skippedEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skippedEntries(BatchGetAssetPropertyValueHistorySkippedEntry ... skippedEntries) {
            this.skippedEntries(Arrays.asList(skippedEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skippedEntries(Consumer<BatchGetAssetPropertyValueHistorySkippedEntry.Builder> ... skippedEntries) {
            this.skippedEntries(Stream.of(skippedEntries).map(c -> (BatchGetAssetPropertyValueHistorySkippedEntry)((BatchGetAssetPropertyValueHistorySkippedEntry.Builder)BatchGetAssetPropertyValueHistorySkippedEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public BatchGetAssetPropertyValueHistoryResponse build() {
            return new BatchGetAssetPropertyValueHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetAssetPropertyValueHistoryResponse> {
        public Builder errorEntries(Collection<BatchGetAssetPropertyValueHistoryErrorEntry> var1);

        public Builder errorEntries(BatchGetAssetPropertyValueHistoryErrorEntry ... var1);

        public Builder errorEntries(Consumer<BatchGetAssetPropertyValueHistoryErrorEntry.Builder> ... var1);

        public Builder successEntries(Collection<BatchGetAssetPropertyValueHistorySuccessEntry> var1);

        public Builder successEntries(BatchGetAssetPropertyValueHistorySuccessEntry ... var1);

        public Builder successEntries(Consumer<BatchGetAssetPropertyValueHistorySuccessEntry.Builder> ... var1);

        public Builder skippedEntries(Collection<BatchGetAssetPropertyValueHistorySkippedEntry> var1);

        public Builder skippedEntries(BatchGetAssetPropertyValueHistorySkippedEntry ... var1);

        public Builder skippedEntries(Consumer<BatchGetAssetPropertyValueHistorySkippedEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

