/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.InputConfiguration;
import software.amazon.awssdk.services.iotevents.model.InputDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Input
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Input> {
    private static final SdkField<InputConfiguration> INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputConfiguration").getter(Input.getter(Input::inputConfiguration)).setter(Input.setter(Builder::inputConfiguration)).constructor(InputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfiguration").build()}).build();
    private static final SdkField<InputDefinition> INPUT_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputDefinition").getter(Input.getter(Input::inputDefinition)).setter(Input.setter(Builder::inputDefinition)).constructor(InputDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_CONFIGURATION_FIELD, INPUT_DEFINITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("inputConfiguration", INPUT_CONFIGURATION_FIELD);
            this.put("inputDefinition", INPUT_DEFINITION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final InputConfiguration inputConfiguration;
    private final InputDefinition inputDefinition;

    private Input(BuilderImpl builder) {
        this.inputConfiguration = builder.inputConfiguration;
        this.inputDefinition = builder.inputDefinition;
    }

    public final InputConfiguration inputConfiguration() {
        return this.inputConfiguration;
    }

    public final InputDefinition inputDefinition() {
        return this.inputDefinition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDefinition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input)obj;
        return Objects.equals(this.inputConfiguration(), other.inputConfiguration()) && Objects.equals(this.inputDefinition(), other.inputDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"Input").add("InputConfiguration", (Object)this.inputConfiguration()).add("InputDefinition", (Object)this.inputDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputConfiguration()));
            }
            case "inputDefinition": {
                return Optional.ofNullable(clazz.cast(this.inputDefinition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Input, T> g) {
        return obj -> g.apply((Input)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InputConfiguration inputConfiguration;
        private InputDefinition inputDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            this.inputConfiguration(model.inputConfiguration);
            this.inputDefinition(model.inputDefinition);
        }

        public final InputConfiguration.Builder getInputConfiguration() {
            return this.inputConfiguration != null ? this.inputConfiguration.toBuilder() : null;
        }

        public final void setInputConfiguration(InputConfiguration.BuilderImpl inputConfiguration) {
            this.inputConfiguration = inputConfiguration != null ? inputConfiguration.build() : null;
        }

        @Override
        public final Builder inputConfiguration(InputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            return this;
        }

        public final InputDefinition.Builder getInputDefinition() {
            return this.inputDefinition != null ? this.inputDefinition.toBuilder() : null;
        }

        public final void setInputDefinition(InputDefinition.BuilderImpl inputDefinition) {
            this.inputDefinition = inputDefinition != null ? inputDefinition.build() : null;
        }

        @Override
        public final Builder inputDefinition(InputDefinition inputDefinition) {
            this.inputDefinition = inputDefinition;
            return this;
        }

        public Input build() {
            return new Input(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Input> {
        public Builder inputConfiguration(InputConfiguration var1);

        default public Builder inputConfiguration(Consumer<InputConfiguration.Builder> inputConfiguration) {
            return this.inputConfiguration((InputConfiguration)((InputConfiguration.Builder)InputConfiguration.builder().applyMutation(inputConfiguration)).build());
        }

        public Builder inputDefinition(InputDefinition var1);

        default public Builder inputDefinition(Consumer<InputDefinition.Builder> inputDefinition) {
            return this.inputDefinition((InputDefinition)((InputDefinition.Builder)InputDefinition.builder().applyMutation(inputDefinition)).build());
        }
    }
}

