/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotanalytics.IoTAnalyticsClient;
import software.amazon.awssdk.services.iotanalytics.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotanalytics.model.ListDatasetsRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListDatasetsResponse;

public class ListDatasetsIterable
implements SdkIterable<ListDatasetsResponse> {
    private final IoTAnalyticsClient client;
    private final ListDatasetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatasetsIterable(IoTAnalyticsClient client, ListDatasetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDatasetsResponseFetcher();
    }

    public Iterator<ListDatasetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDatasetsResponseFetcher
    implements SyncPageFetcher<ListDatasetsResponse> {
        private ListDatasetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatasetsResponse nextPage(ListDatasetsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetsIterable.this.client.listDatasets(ListDatasetsIterable.this.firstRequest);
            }
            return ListDatasetsIterable.this.client.listDatasets((ListDatasetsRequest)((Object)ListDatasetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

