/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.PutItemInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DynamoDBv2Action
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DynamoDBv2Action> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DynamoDBv2Action.getter(DynamoDBv2Action::roleArn)).setter(DynamoDBv2Action.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<PutItemInput> PUT_ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("putItem").getter(DynamoDBv2Action.getter(DynamoDBv2Action::putItem)).setter(DynamoDBv2Action.setter(Builder::putItem)).constructor(PutItemInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("putItem").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, PUT_ITEM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("putItem", PUT_ITEM_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final PutItemInput putItem;

    private DynamoDBv2Action(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.putItem = builder.putItem;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final PutItemInput putItem() {
        return this.putItem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.putItem());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBv2Action)) {
            return false;
        }
        DynamoDBv2Action other = (DynamoDBv2Action)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.putItem(), other.putItem());
    }

    public final String toString() {
        return ToString.builder((String)"DynamoDBv2Action").add("RoleArn", (Object)this.roleArn()).add("PutItem", (Object)this.putItem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "putItem": {
                return Optional.ofNullable(clazz.cast(this.putItem()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DynamoDBv2Action, T> g) {
        return obj -> g.apply((DynamoDBv2Action)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private PutItemInput putItem;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDBv2Action model) {
            this.roleArn(model.roleArn);
            this.putItem(model.putItem);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final PutItemInput.Builder getPutItem() {
            return this.putItem != null ? this.putItem.toBuilder() : null;
        }

        public final void setPutItem(PutItemInput.BuilderImpl putItem) {
            this.putItem = putItem != null ? putItem.build() : null;
        }

        @Override
        public final Builder putItem(PutItemInput putItem) {
            this.putItem = putItem;
            return this;
        }

        public DynamoDBv2Action build() {
            return new DynamoDBv2Action(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DynamoDBv2Action> {
        public Builder roleArn(String var1);

        public Builder putItem(PutItemInput var1);

        default public Builder putItem(Consumer<PutItemInput.Builder> putItem) {
            return this.putItem((PutItemInput)((PutItemInput.Builder)PutItemInput.builder().applyMutation(putItem)).build());
        }
    }
}

