/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCertificateFromCsrResponse
extends IotResponse
implements ToCopyableBuilder<Builder, CreateCertificateFromCsrResponse> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateArn").getter(CreateCertificateFromCsrResponse.getter(CreateCertificateFromCsrResponse::certificateArn)).setter(CreateCertificateFromCsrResponse.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateId").getter(CreateCertificateFromCsrResponse.getter(CreateCertificateFromCsrResponse::certificateId)).setter(CreateCertificateFromCsrResponse.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateId").build()}).build();
    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificatePem").getter(CreateCertificateFromCsrResponse.getter(CreateCertificateFromCsrResponse::certificatePem)).setter(CreateCertificateFromCsrResponse.setter(Builder::certificatePem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePem").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, CERTIFICATE_ID_FIELD, CERTIFICATE_PEM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("certificateArn", CERTIFICATE_ARN_FIELD);
            this.put("certificateId", CERTIFICATE_ID_FIELD);
            this.put("certificatePem", CERTIFICATE_PEM_FIELD);
        }
    });
    private final String certificateArn;
    private final String certificateId;
    private final String certificatePem;

    private CreateCertificateFromCsrResponse(BuilderImpl builder) {
        super(builder);
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.certificatePem = builder.certificatePem;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final String certificateId() {
        return this.certificateId;
    }

    public final String certificatePem() {
        return this.certificatePem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePem());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCertificateFromCsrResponse)) {
            return false;
        }
        CreateCertificateFromCsrResponse other = (CreateCertificateFromCsrResponse)((Object)obj);
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.certificatePem(), other.certificatePem());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCertificateFromCsrResponse").add("CertificateArn", (Object)this.certificateArn()).add("CertificateId", (Object)this.certificateId()).add("CertificatePem", (Object)this.certificatePem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "certificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "certificatePem": {
                return Optional.ofNullable(clazz.cast(this.certificatePem()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCertificateFromCsrResponse, T> g) {
        return obj -> g.apply((CreateCertificateFromCsrResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String certificateArn;
        private String certificateId;
        private String certificatePem;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCertificateFromCsrResponse model) {
            super(model);
            this.certificateArn(model.certificateArn);
            this.certificateId(model.certificateId);
            this.certificatePem(model.certificatePem);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        @Override
        public CreateCertificateFromCsrResponse build() {
            return new CreateCertificateFromCsrResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCertificateFromCsrResponse> {
        public Builder certificateArn(String var1);

        public Builder certificateId(String var1);

        public Builder certificatePem(String var1);
    }
}

