/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.internetmonitor.model.InternetEventSummary;
import software.amazon.awssdk.services.internetmonitor.model.InternetEventsListCopier;
import software.amazon.awssdk.services.internetmonitor.model.InternetMonitorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInternetEventsResponse
extends InternetMonitorResponse
implements ToCopyableBuilder<Builder, ListInternetEventsResponse> {
    private static final SdkField<List<InternetEventSummary>> INTERNET_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InternetEvents").getter(ListInternetEventsResponse.getter(ListInternetEventsResponse::internetEvents)).setter(ListInternetEventsResponse.setter(Builder::internetEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InternetEventSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInternetEventsResponse.getter(ListInternetEventsResponse::nextToken)).setter(ListInternetEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERNET_EVENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InternetEvents", INTERNET_EVENTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<InternetEventSummary> internetEvents;
    private final String nextToken;

    private ListInternetEventsResponse(BuilderImpl builder) {
        super(builder);
        this.internetEvents = builder.internetEvents;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInternetEvents() {
        return this.internetEvents != null && !(this.internetEvents instanceof SdkAutoConstructList);
    }

    public final List<InternetEventSummary> internetEvents() {
        return this.internetEvents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInternetEvents() ? this.internetEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInternetEventsResponse)) {
            return false;
        }
        ListInternetEventsResponse other = (ListInternetEventsResponse)((Object)obj);
        return this.hasInternetEvents() == other.hasInternetEvents() && Objects.equals(this.internetEvents(), other.internetEvents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInternetEventsResponse").add("InternetEvents", this.hasInternetEvents() ? this.internetEvents() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InternetEvents": {
                return Optional.ofNullable(clazz.cast(this.internetEvents()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListInternetEventsResponse, T> g) {
        return obj -> g.apply((ListInternetEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InternetMonitorResponse.BuilderImpl
    implements Builder {
        private List<InternetEventSummary> internetEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInternetEventsResponse model) {
            super(model);
            this.internetEvents(model.internetEvents);
            this.nextToken(model.nextToken);
        }

        public final List<InternetEventSummary.Builder> getInternetEvents() {
            List<InternetEventSummary.Builder> result = InternetEventsListCopier.copyToBuilder(this.internetEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInternetEvents(Collection<InternetEventSummary.BuilderImpl> internetEvents) {
            this.internetEvents = InternetEventsListCopier.copyFromBuilder(internetEvents);
        }

        @Override
        public final Builder internetEvents(Collection<InternetEventSummary> internetEvents) {
            this.internetEvents = InternetEventsListCopier.copy(internetEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetEvents(InternetEventSummary ... internetEvents) {
            this.internetEvents(Arrays.asList(internetEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetEvents(Consumer<InternetEventSummary.Builder> ... internetEvents) {
            this.internetEvents(Stream.of(internetEvents).map(c -> (InternetEventSummary)((InternetEventSummary.Builder)InternetEventSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInternetEventsResponse build() {
            return new ListInternetEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends InternetMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInternetEventsResponse> {
        public Builder internetEvents(Collection<InternetEventSummary> var1);

        public Builder internetEvents(InternetEventSummary ... var1);

        public Builder internetEvents(Consumer<InternetEventSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

