/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.AggregationResponse;
import software.amazon.awssdk.services.inspector2.model.AggregationResponseListCopier;
import software.amazon.awssdk.services.inspector2.model.AggregationType;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFindingAggregationsResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, ListFindingAggregationsResponse> {
    private static final SdkField<String> AGGREGATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregationType").getter(ListFindingAggregationsResponse.getter(ListFindingAggregationsResponse::aggregationTypeAsString)).setter(ListFindingAggregationsResponse.setter(Builder::aggregationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFindingAggregationsResponse.getter(ListFindingAggregationsResponse::nextToken)).setter(ListFindingAggregationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<AggregationResponse>> RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("responses").getter(ListFindingAggregationsResponse.getter(ListFindingAggregationsResponse::responses)).setter(ListFindingAggregationsResponse.setter(Builder::responses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_TYPE_FIELD, NEXT_TOKEN_FIELD, RESPONSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("aggregationType", AGGREGATION_TYPE_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("responses", RESPONSES_FIELD);
        }
    });
    private final String aggregationType;
    private final String nextToken;
    private final List<AggregationResponse> responses;

    private ListFindingAggregationsResponse(BuilderImpl builder) {
        super(builder);
        this.aggregationType = builder.aggregationType;
        this.nextToken = builder.nextToken;
        this.responses = builder.responses;
    }

    public final AggregationType aggregationType() {
        return AggregationType.fromValue(this.aggregationType);
    }

    public final String aggregationTypeAsString() {
        return this.aggregationType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasResponses() {
        return this.responses != null && !(this.responses instanceof SdkAutoConstructList);
    }

    public final List<AggregationResponse> responses() {
        return this.responses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponses() ? this.responses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingAggregationsResponse)) {
            return false;
        }
        ListFindingAggregationsResponse other = (ListFindingAggregationsResponse)((Object)obj);
        return Objects.equals(this.aggregationTypeAsString(), other.aggregationTypeAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasResponses() == other.hasResponses() && Objects.equals(this.responses(), other.responses());
    }

    public final String toString() {
        return ToString.builder((String)"ListFindingAggregationsResponse").add("AggregationType", (Object)this.aggregationTypeAsString()).add("NextToken", (Object)this.nextToken()).add("Responses", this.hasResponses() ? this.responses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aggregationType": {
                return Optional.ofNullable(clazz.cast(this.aggregationTypeAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "responses": {
                return Optional.ofNullable(clazz.cast(this.responses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingAggregationsResponse, T> g) {
        return obj -> g.apply((ListFindingAggregationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private String aggregationType;
        private String nextToken;
        private List<AggregationResponse> responses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingAggregationsResponse model) {
            super(model);
            this.aggregationType(model.aggregationType);
            this.nextToken(model.nextToken);
            this.responses(model.responses);
        }

        public final String getAggregationType() {
            return this.aggregationType;
        }

        public final void setAggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
        }

        @Override
        public final Builder aggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        @Override
        public final Builder aggregationType(AggregationType aggregationType) {
            this.aggregationType(aggregationType == null ? null : aggregationType.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AggregationResponse.Builder> getResponses() {
            List<AggregationResponse.Builder> result = AggregationResponseListCopier.copyToBuilder(this.responses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponses(Collection<AggregationResponse.BuilderImpl> responses) {
            this.responses = AggregationResponseListCopier.copyFromBuilder(responses);
        }

        @Override
        public final Builder responses(Collection<AggregationResponse> responses) {
            this.responses = AggregationResponseListCopier.copy(responses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(AggregationResponse ... responses) {
            this.responses(Arrays.asList(responses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(Consumer<AggregationResponse.Builder> ... responses) {
            this.responses(Stream.of(responses).map(c -> (AggregationResponse)((AggregationResponse.Builder)AggregationResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFindingAggregationsResponse build() {
            return new ListFindingAggregationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFindingAggregationsResponse> {
        public Builder aggregationType(String var1);

        public Builder aggregationType(AggregationType var1);

        public Builder nextToken(String var1);

        public Builder responses(Collection<AggregationResponse> var1);

        public Builder responses(AggregationResponse ... var1);

        public Builder responses(Consumer<AggregationResponse.Builder> ... var1);
    }
}

