/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicySummary;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecyclePoliciesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecyclePoliciesResponse;

public class ListLifecyclePoliciesPublisher
implements SdkPublisher<ListLifecyclePoliciesResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListLifecyclePoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLifecyclePoliciesPublisher(ImagebuilderAsyncClient client, ListLifecyclePoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLifecyclePoliciesPublisher(ImagebuilderAsyncClient client, ListLifecyclePoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLifecyclePoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLifecyclePoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LifecyclePolicySummary> lifecyclePolicySummaryList() {
        Function<ListLifecyclePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.lifecyclePolicySummaryList() != null) {
                return response.lifecyclePolicySummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLifecyclePoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLifecyclePoliciesResponseFetcher
    implements AsyncPageFetcher<ListLifecyclePoliciesResponse> {
        private ListLifecyclePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListLifecyclePoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLifecyclePoliciesResponse> nextPage(ListLifecyclePoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListLifecyclePoliciesPublisher.this.client.listLifecyclePolicies(ListLifecyclePoliciesPublisher.this.firstRequest);
            }
            return ListLifecyclePoliciesPublisher.this.client.listLifecyclePolicies((ListLifecyclePoliciesRequest)((Object)ListLifecyclePoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

