/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.LifecycleExecution;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsResponse;

public class ListLifecycleExecutionsIterable
implements SdkIterable<ListLifecycleExecutionsResponse> {
    private final ImagebuilderClient client;
    private final ListLifecycleExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLifecycleExecutionsIterable(ImagebuilderClient client, ListLifecycleExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLifecycleExecutionsResponseFetcher();
    }

    public Iterator<ListLifecycleExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LifecycleExecution> lifecycleExecutions() {
        Function<ListLifecycleExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.lifecycleExecutions() != null) {
                return response.lifecycleExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLifecycleExecutionsResponseFetcher
    implements SyncPageFetcher<ListLifecycleExecutionsResponse> {
        private ListLifecycleExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListLifecycleExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLifecycleExecutionsResponse nextPage(ListLifecycleExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListLifecycleExecutionsIterable.this.client.listLifecycleExecutions(ListLifecycleExecutionsIterable.this.firstRequest);
            }
            return ListLifecycleExecutionsIterable.this.client.listLifecycleExecutions((ListLifecycleExecutionsRequest)((Object)ListLifecycleExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

