/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkflowResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, CreateWorkflowResponse> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::clientToken)).setter(CreateWorkflowResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> WORKFLOW_BUILD_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowBuildVersionArn").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::workflowBuildVersionArn)).setter(CreateWorkflowResponse.setter(Builder::workflowBuildVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowBuildVersionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, WORKFLOW_BUILD_VERSION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("workflowBuildVersionArn", WORKFLOW_BUILD_VERSION_ARN_FIELD);
        }
    });
    private final String clientToken;
    private final String workflowBuildVersionArn;

    private CreateWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.workflowBuildVersionArn = builder.workflowBuildVersionArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String workflowBuildVersionArn() {
        return this.workflowBuildVersionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowBuildVersionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowResponse)) {
            return false;
        }
        CreateWorkflowResponse other = (CreateWorkflowResponse)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.workflowBuildVersionArn(), other.workflowBuildVersionArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkflowResponse").add("ClientToken", (Object)this.clientToken()).add("WorkflowBuildVersionArn", (Object)this.workflowBuildVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "workflowBuildVersionArn": {
                return Optional.ofNullable(clazz.cast(this.workflowBuildVersionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowResponse, T> g) {
        return obj -> g.apply((CreateWorkflowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String clientToken;
        private String workflowBuildVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowResponse model) {
            super(model);
            this.clientToken(model.clientToken);
            this.workflowBuildVersionArn(model.workflowBuildVersionArn);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getWorkflowBuildVersionArn() {
            return this.workflowBuildVersionArn;
        }

        public final void setWorkflowBuildVersionArn(String workflowBuildVersionArn) {
            this.workflowBuildVersionArn = workflowBuildVersionArn;
        }

        @Override
        public final Builder workflowBuildVersionArn(String workflowBuildVersionArn) {
            this.workflowBuildVersionArn = workflowBuildVersionArn;
            return this;
        }

        @Override
        public CreateWorkflowResponse build() {
            return new CreateWorkflowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkflowResponse> {
        public Builder clientToken(String var1);

        public Builder workflowBuildVersionArn(String var1);
    }
}

