/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.healthlake.model.HealthLakeRequest;
import software.amazon.awssdk.services.healthlake.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFhirExportJobsRequest
extends HealthLakeRequest
implements ToCopyableBuilder<Builder, ListFhirExportJobsRequest> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreId").getter(ListFhirExportJobsRequest.getter(ListFhirExportJobsRequest::datastoreId)).setter(ListFhirExportJobsRequest.setter(Builder::datastoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFhirExportJobsRequest.getter(ListFhirExportJobsRequest::nextToken)).setter(ListFhirExportJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListFhirExportJobsRequest.getter(ListFhirExportJobsRequest::maxResults)).setter(ListFhirExportJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(ListFhirExportJobsRequest.getter(ListFhirExportJobsRequest::jobName)).setter(ListFhirExportJobsRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(ListFhirExportJobsRequest.getter(ListFhirExportJobsRequest::jobStatusAsString)).setter(ListFhirExportJobsRequest.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<Instant> SUBMITTED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmittedBefore").getter(ListFhirExportJobsRequest.getter(ListFhirExportJobsRequest::submittedBefore)).setter(ListFhirExportJobsRequest.setter(Builder::submittedBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedBefore").build()}).build();
    private static final SdkField<Instant> SUBMITTED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmittedAfter").getter(ListFhirExportJobsRequest.getter(ListFhirExportJobsRequest::submittedAfter)).setter(ListFhirExportJobsRequest.setter(Builder::submittedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedAfter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, JOB_NAME_FIELD, JOB_STATUS_FIELD, SUBMITTED_BEFORE_FIELD, SUBMITTED_AFTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DatastoreId", DATASTORE_ID_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("JobName", JOB_NAME_FIELD);
            this.put("JobStatus", JOB_STATUS_FIELD);
            this.put("SubmittedBefore", SUBMITTED_BEFORE_FIELD);
            this.put("SubmittedAfter", SUBMITTED_AFTER_FIELD);
        }
    });
    private final String datastoreId;
    private final String nextToken;
    private final Integer maxResults;
    private final String jobName;
    private final String jobStatus;
    private final Instant submittedBefore;
    private final Instant submittedAfter;

    private ListFhirExportJobsRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.submittedBefore = builder.submittedBefore;
        this.submittedAfter = builder.submittedAfter;
    }

    public final String datastoreId() {
        return this.datastoreId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final Instant submittedBefore() {
        return this.submittedBefore;
    }

    public final Instant submittedAfter() {
        return this.submittedAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedAfter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFhirExportJobsRequest)) {
            return false;
        }
        ListFhirExportJobsRequest other = (ListFhirExportJobsRequest)((Object)obj);
        return Objects.equals(this.datastoreId(), other.datastoreId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.submittedBefore(), other.submittedBefore()) && Objects.equals(this.submittedAfter(), other.submittedAfter());
    }

    public final String toString() {
        return ToString.builder((String)"ListFhirExportJobsRequest").add("DatastoreId", (Object)this.datastoreId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("JobName", (Object)this.jobName()).add("JobStatus", (Object)this.jobStatusAsString()).add("SubmittedBefore", (Object)this.submittedBefore()).add("SubmittedAfter", (Object)this.submittedAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatastoreId": {
                return Optional.ofNullable(clazz.cast(this.datastoreId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "SubmittedBefore": {
                return Optional.ofNullable(clazz.cast(this.submittedBefore()));
            }
            case "SubmittedAfter": {
                return Optional.ofNullable(clazz.cast(this.submittedAfter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListFhirExportJobsRequest, T> g) {
        return obj -> g.apply((ListFhirExportJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthLakeRequest.BuilderImpl
    implements Builder {
        private String datastoreId;
        private String nextToken;
        private Integer maxResults;
        private String jobName;
        private String jobStatus;
        private Instant submittedBefore;
        private Instant submittedAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFhirExportJobsRequest model) {
            super(model);
            this.datastoreId(model.datastoreId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.jobName(model.jobName);
            this.jobStatus(model.jobStatus);
            this.submittedBefore(model.submittedBefore);
            this.submittedAfter(model.submittedAfter);
        }

        public final String getDatastoreId() {
            return this.datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getSubmittedBefore() {
            return this.submittedBefore;
        }

        public final void setSubmittedBefore(Instant submittedBefore) {
            this.submittedBefore = submittedBefore;
        }

        @Override
        public final Builder submittedBefore(Instant submittedBefore) {
            this.submittedBefore = submittedBefore;
            return this;
        }

        public final Instant getSubmittedAfter() {
            return this.submittedAfter;
        }

        public final void setSubmittedAfter(Instant submittedAfter) {
            this.submittedAfter = submittedAfter;
        }

        @Override
        public final Builder submittedAfter(Instant submittedAfter) {
            this.submittedAfter = submittedAfter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFhirExportJobsRequest build() {
            return new ListFhirExportJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends HealthLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFhirExportJobsRequest> {
        public Builder datastoreId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder jobName(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder submittedBefore(Instant var1);

        public Builder submittedAfter(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

