/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.EventScopeCode;
import software.amazon.awssdk.services.health.model.HealthResponse;
import software.amazon.awssdk.services.health.model._affectedAccountsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAffectedAccountsForOrganizationResponse
extends HealthResponse
implements ToCopyableBuilder<Builder, DescribeAffectedAccountsForOrganizationResponse> {
    private static final SdkField<List<String>> AFFECTED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("affectedAccounts").getter(DescribeAffectedAccountsForOrganizationResponse.getter(DescribeAffectedAccountsForOrganizationResponse::affectedAccounts)).setter(DescribeAffectedAccountsForOrganizationResponse.setter(Builder::affectedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("affectedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVENT_SCOPE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventScopeCode").getter(DescribeAffectedAccountsForOrganizationResponse.getter(DescribeAffectedAccountsForOrganizationResponse::eventScopeCodeAsString)).setter(DescribeAffectedAccountsForOrganizationResponse.setter(Builder::eventScopeCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventScopeCode").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeAffectedAccountsForOrganizationResponse.getter(DescribeAffectedAccountsForOrganizationResponse::nextToken)).setter(DescribeAffectedAccountsForOrganizationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFECTED_ACCOUNTS_FIELD, EVENT_SCOPE_CODE_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("affectedAccounts", AFFECTED_ACCOUNTS_FIELD);
            this.put("eventScopeCode", EVENT_SCOPE_CODE_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<String> affectedAccounts;
    private final String eventScopeCode;
    private final String nextToken;

    private DescribeAffectedAccountsForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.affectedAccounts = builder.affectedAccounts;
        this.eventScopeCode = builder.eventScopeCode;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAffectedAccounts() {
        return this.affectedAccounts != null && !(this.affectedAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> affectedAccounts() {
        return this.affectedAccounts;
    }

    public final EventScopeCode eventScopeCode() {
        return EventScopeCode.fromValue(this.eventScopeCode);
    }

    public final String eventScopeCodeAsString() {
        return this.eventScopeCode;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAffectedAccounts() ? this.affectedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventScopeCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAffectedAccountsForOrganizationResponse)) {
            return false;
        }
        DescribeAffectedAccountsForOrganizationResponse other = (DescribeAffectedAccountsForOrganizationResponse)((Object)obj);
        return this.hasAffectedAccounts() == other.hasAffectedAccounts() && Objects.equals(this.affectedAccounts(), other.affectedAccounts()) && Objects.equals(this.eventScopeCodeAsString(), other.eventScopeCodeAsString()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAffectedAccountsForOrganizationResponse").add("AffectedAccounts", this.hasAffectedAccounts() ? this.affectedAccounts() : null).add("EventScopeCode", (Object)this.eventScopeCodeAsString()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "affectedAccounts": {
                return Optional.ofNullable(clazz.cast(this.affectedAccounts()));
            }
            case "eventScopeCode": {
                return Optional.ofNullable(clazz.cast(this.eventScopeCodeAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAffectedAccountsForOrganizationResponse, T> g) {
        return obj -> g.apply((DescribeAffectedAccountsForOrganizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthResponse.BuilderImpl
    implements Builder {
        private List<String> affectedAccounts = DefaultSdkAutoConstructList.getInstance();
        private String eventScopeCode;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAffectedAccountsForOrganizationResponse model) {
            super(model);
            this.affectedAccounts(model.affectedAccounts);
            this.eventScopeCode(model.eventScopeCode);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAffectedAccounts() {
            if (this.affectedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.affectedAccounts;
        }

        public final void setAffectedAccounts(Collection<String> affectedAccounts) {
            this.affectedAccounts = _affectedAccountsListCopier.copy(affectedAccounts);
        }

        @Override
        public final Builder affectedAccounts(Collection<String> affectedAccounts) {
            this.affectedAccounts = _affectedAccountsListCopier.copy(affectedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder affectedAccounts(String ... affectedAccounts) {
            this.affectedAccounts(Arrays.asList(affectedAccounts));
            return this;
        }

        public final String getEventScopeCode() {
            return this.eventScopeCode;
        }

        public final void setEventScopeCode(String eventScopeCode) {
            this.eventScopeCode = eventScopeCode;
        }

        @Override
        public final Builder eventScopeCode(String eventScopeCode) {
            this.eventScopeCode = eventScopeCode;
            return this;
        }

        @Override
        public final Builder eventScopeCode(EventScopeCode eventScopeCode) {
            this.eventScopeCode(eventScopeCode == null ? null : eventScopeCode.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAffectedAccountsForOrganizationResponse build() {
            return new DescribeAffectedAccountsForOrganizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends HealthResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAffectedAccountsForOrganizationResponse> {
        public Builder affectedAccounts(Collection<String> var1);

        public Builder affectedAccounts(String ... var1);

        public Builder eventScopeCode(String var1);

        public Builder eventScopeCode(EventScopeCode var1);

        public Builder nextToken(String var1);
    }
}

