/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.City;
import software.amazon.awssdk.services.guardduty.model.Country;
import software.amazon.awssdk.services.guardduty.model.GeoLocation;
import software.amazon.awssdk.services.guardduty.model.Organization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoteIpDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RemoteIpDetails> {
    private static final SdkField<City> CITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("City").getter(RemoteIpDetails.getter(RemoteIpDetails::city)).setter(RemoteIpDetails.setter(Builder::city)).constructor(City::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("city").build()}).build();
    private static final SdkField<Country> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Country").getter(RemoteIpDetails.getter(RemoteIpDetails::country)).setter(RemoteIpDetails.setter(Builder::country)).constructor(Country::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("country").build()}).build();
    private static final SdkField<GeoLocation> GEO_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GeoLocation").getter(RemoteIpDetails.getter(RemoteIpDetails::geoLocation)).setter(RemoteIpDetails.setter(Builder::geoLocation)).constructor(GeoLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("geoLocation").build()}).build();
    private static final SdkField<String> IP_ADDRESS_V4_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressV4").getter(RemoteIpDetails.getter(RemoteIpDetails::ipAddressV4)).setter(RemoteIpDetails.setter(Builder::ipAddressV4)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressV4").build()}).build();
    private static final SdkField<String> IP_ADDRESS_V6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressV6").getter(RemoteIpDetails.getter(RemoteIpDetails::ipAddressV6)).setter(RemoteIpDetails.setter(Builder::ipAddressV6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressV6").build()}).build();
    private static final SdkField<Organization> ORGANIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Organization").getter(RemoteIpDetails.getter(RemoteIpDetails::organization)).setter(RemoteIpDetails.setter(Builder::organization)).constructor(Organization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITY_FIELD, COUNTRY_FIELD, GEO_LOCATION_FIELD, IP_ADDRESS_V4_FIELD, IP_ADDRESS_V6_FIELD, ORGANIZATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("city", CITY_FIELD);
            this.put("country", COUNTRY_FIELD);
            this.put("geoLocation", GEO_LOCATION_FIELD);
            this.put("ipAddressV4", IP_ADDRESS_V4_FIELD);
            this.put("ipAddressV6", IP_ADDRESS_V6_FIELD);
            this.put("organization", ORGANIZATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final City city;
    private final Country country;
    private final GeoLocation geoLocation;
    private final String ipAddressV4;
    private final String ipAddressV6;
    private final Organization organization;

    private RemoteIpDetails(BuilderImpl builder) {
        this.city = builder.city;
        this.country = builder.country;
        this.geoLocation = builder.geoLocation;
        this.ipAddressV4 = builder.ipAddressV4;
        this.ipAddressV6 = builder.ipAddressV6;
        this.organization = builder.organization;
    }

    public final City city() {
        return this.city;
    }

    public final Country country() {
        return this.country;
    }

    public final GeoLocation geoLocation() {
        return this.geoLocation;
    }

    public final String ipAddressV4() {
        return this.ipAddressV4;
    }

    public final String ipAddressV6() {
        return this.ipAddressV6;
    }

    public final Organization organization() {
        return this.organization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.geoLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressV4());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressV6());
        hashCode = 31 * hashCode + Objects.hashCode(this.organization());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteIpDetails)) {
            return false;
        }
        RemoteIpDetails other = (RemoteIpDetails)obj;
        return Objects.equals(this.city(), other.city()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.geoLocation(), other.geoLocation()) && Objects.equals(this.ipAddressV4(), other.ipAddressV4()) && Objects.equals(this.ipAddressV6(), other.ipAddressV6()) && Objects.equals(this.organization(), other.organization());
    }

    public final String toString() {
        return ToString.builder((String)"RemoteIpDetails").add("City", (Object)this.city()).add("Country", (Object)this.country()).add("GeoLocation", (Object)this.geoLocation()).add("IpAddressV4", (Object)(this.ipAddressV4() == null ? null : "*** Sensitive Data Redacted ***")).add("IpAddressV6", (Object)(this.ipAddressV6() == null ? null : "*** Sensitive Data Redacted ***")).add("Organization", (Object)this.organization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "City": {
                return Optional.ofNullable(clazz.cast(this.city()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "GeoLocation": {
                return Optional.ofNullable(clazz.cast(this.geoLocation()));
            }
            case "IpAddressV4": {
                return Optional.ofNullable(clazz.cast(this.ipAddressV4()));
            }
            case "IpAddressV6": {
                return Optional.ofNullable(clazz.cast(this.ipAddressV6()));
            }
            case "Organization": {
                return Optional.ofNullable(clazz.cast(this.organization()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RemoteIpDetails, T> g) {
        return obj -> g.apply((RemoteIpDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private City city;
        private Country country;
        private GeoLocation geoLocation;
        private String ipAddressV4;
        private String ipAddressV6;
        private Organization organization;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteIpDetails model) {
            this.city(model.city);
            this.country(model.country);
            this.geoLocation(model.geoLocation);
            this.ipAddressV4(model.ipAddressV4);
            this.ipAddressV6(model.ipAddressV6);
            this.organization(model.organization);
        }

        public final City.Builder getCity() {
            return this.city != null ? this.city.toBuilder() : null;
        }

        public final void setCity(City.BuilderImpl city) {
            this.city = city != null ? city.build() : null;
        }

        @Override
        public final Builder city(City city) {
            this.city = city;
            return this;
        }

        public final Country.Builder getCountry() {
            return this.country != null ? this.country.toBuilder() : null;
        }

        public final void setCountry(Country.BuilderImpl country) {
            this.country = country != null ? country.build() : null;
        }

        @Override
        public final Builder country(Country country) {
            this.country = country;
            return this;
        }

        public final GeoLocation.Builder getGeoLocation() {
            return this.geoLocation != null ? this.geoLocation.toBuilder() : null;
        }

        public final void setGeoLocation(GeoLocation.BuilderImpl geoLocation) {
            this.geoLocation = geoLocation != null ? geoLocation.build() : null;
        }

        @Override
        public final Builder geoLocation(GeoLocation geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        public final String getIpAddressV4() {
            return this.ipAddressV4;
        }

        public final void setIpAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
        }

        @Override
        public final Builder ipAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
            return this;
        }

        public final String getIpAddressV6() {
            return this.ipAddressV6;
        }

        public final void setIpAddressV6(String ipAddressV6) {
            this.ipAddressV6 = ipAddressV6;
        }

        @Override
        public final Builder ipAddressV6(String ipAddressV6) {
            this.ipAddressV6 = ipAddressV6;
            return this;
        }

        public final Organization.Builder getOrganization() {
            return this.organization != null ? this.organization.toBuilder() : null;
        }

        public final void setOrganization(Organization.BuilderImpl organization) {
            this.organization = organization != null ? organization.build() : null;
        }

        @Override
        public final Builder organization(Organization organization) {
            this.organization = organization;
            return this;
        }

        public RemoteIpDetails build() {
            return new RemoteIpDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RemoteIpDetails> {
        public Builder city(City var1);

        default public Builder city(Consumer<City.Builder> city) {
            return this.city((City)((City.Builder)City.builder().applyMutation(city)).build());
        }

        public Builder country(Country var1);

        default public Builder country(Consumer<Country.Builder> country) {
            return this.country((Country)((Country.Builder)Country.builder().applyMutation(country)).build());
        }

        public Builder geoLocation(GeoLocation var1);

        default public Builder geoLocation(Consumer<GeoLocation.Builder> geoLocation) {
            return this.geoLocation((GeoLocation)((GeoLocation.Builder)GeoLocation.builder().applyMutation(geoLocation)).build());
        }

        public Builder ipAddressV4(String var1);

        public Builder ipAddressV6(String var1);

        public Builder organization(Organization var1);

        default public Builder organization(Consumer<Organization.Builder> organization) {
            return this.organization((Organization)((Organization.Builder)Organization.builder().applyMutation(organization)).build());
        }
    }
}

