/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.Frequency;
import software.amazon.awssdk.services.groundstation.model.FrequencyBandwidth;
import software.amazon.awssdk.services.groundstation.model.Polarization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpectrumConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpectrumConfig> {
    private static final SdkField<FrequencyBandwidth> BANDWIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bandwidth").getter(SpectrumConfig.getter(SpectrumConfig::bandwidth)).setter(SpectrumConfig.setter(Builder::bandwidth)).constructor(FrequencyBandwidth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidth").build()}).build();
    private static final SdkField<Frequency> CENTER_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("centerFrequency").getter(SpectrumConfig.getter(SpectrumConfig::centerFrequency)).setter(SpectrumConfig.setter(Builder::centerFrequency)).constructor(Frequency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("centerFrequency").build()}).build();
    private static final SdkField<String> POLARIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("polarization").getter(SpectrumConfig.getter(SpectrumConfig::polarizationAsString)).setter(SpectrumConfig.setter(Builder::polarization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("polarization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BANDWIDTH_FIELD, CENTER_FREQUENCY_FIELD, POLARIZATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("bandwidth", BANDWIDTH_FIELD);
            this.put("centerFrequency", CENTER_FREQUENCY_FIELD);
            this.put("polarization", POLARIZATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final FrequencyBandwidth bandwidth;
    private final Frequency centerFrequency;
    private final String polarization;

    private SpectrumConfig(BuilderImpl builder) {
        this.bandwidth = builder.bandwidth;
        this.centerFrequency = builder.centerFrequency;
        this.polarization = builder.polarization;
    }

    public final FrequencyBandwidth bandwidth() {
        return this.bandwidth;
    }

    public final Frequency centerFrequency() {
        return this.centerFrequency;
    }

    public final Polarization polarization() {
        return Polarization.fromValue(this.polarization);
    }

    public final String polarizationAsString() {
        return this.polarization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.centerFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.polarizationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpectrumConfig)) {
            return false;
        }
        SpectrumConfig other = (SpectrumConfig)obj;
        return Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.centerFrequency(), other.centerFrequency()) && Objects.equals(this.polarizationAsString(), other.polarizationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SpectrumConfig").add("Bandwidth", (Object)this.bandwidth()).add("CenterFrequency", (Object)this.centerFrequency()).add("Polarization", (Object)this.polarizationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bandwidth": {
                return Optional.ofNullable(clazz.cast(this.bandwidth()));
            }
            case "centerFrequency": {
                return Optional.ofNullable(clazz.cast(this.centerFrequency()));
            }
            case "polarization": {
                return Optional.ofNullable(clazz.cast(this.polarizationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SpectrumConfig, T> g) {
        return obj -> g.apply((SpectrumConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FrequencyBandwidth bandwidth;
        private Frequency centerFrequency;
        private String polarization;

        private BuilderImpl() {
        }

        private BuilderImpl(SpectrumConfig model) {
            this.bandwidth(model.bandwidth);
            this.centerFrequency(model.centerFrequency);
            this.polarization(model.polarization);
        }

        public final FrequencyBandwidth.Builder getBandwidth() {
            return this.bandwidth != null ? this.bandwidth.toBuilder() : null;
        }

        public final void setBandwidth(FrequencyBandwidth.BuilderImpl bandwidth) {
            this.bandwidth = bandwidth != null ? bandwidth.build() : null;
        }

        @Override
        public final Builder bandwidth(FrequencyBandwidth bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final Frequency.Builder getCenterFrequency() {
            return this.centerFrequency != null ? this.centerFrequency.toBuilder() : null;
        }

        public final void setCenterFrequency(Frequency.BuilderImpl centerFrequency) {
            this.centerFrequency = centerFrequency != null ? centerFrequency.build() : null;
        }

        @Override
        public final Builder centerFrequency(Frequency centerFrequency) {
            this.centerFrequency = centerFrequency;
            return this;
        }

        public final String getPolarization() {
            return this.polarization;
        }

        public final void setPolarization(String polarization) {
            this.polarization = polarization;
        }

        @Override
        public final Builder polarization(String polarization) {
            this.polarization = polarization;
            return this;
        }

        @Override
        public final Builder polarization(Polarization polarization) {
            this.polarization(polarization == null ? null : polarization.toString());
            return this;
        }

        public SpectrumConfig build() {
            return new SpectrumConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpectrumConfig> {
        public Builder bandwidth(FrequencyBandwidth var1);

        default public Builder bandwidth(Consumer<FrequencyBandwidth.Builder> bandwidth) {
            return this.bandwidth((FrequencyBandwidth)((FrequencyBandwidth.Builder)FrequencyBandwidth.builder().applyMutation(bandwidth)).build());
        }

        public Builder centerFrequency(Frequency var1);

        default public Builder centerFrequency(Consumer<Frequency.Builder> centerFrequency) {
            return this.centerFrequency((Frequency)((Frequency.Builder)Frequency.builder().applyMutation(centerFrequency)).build());
        }

        public Builder polarization(String var1);

        public Builder polarization(Polarization var1);
    }
}

