/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.ContactStatus;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.services.groundstation.model.StatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContactsRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, ListContactsRequest> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ListContactsRequest.getter(ListContactsRequest::endTime)).setter(ListContactsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> GROUND_STATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groundStation").getter(ListContactsRequest.getter(ListContactsRequest::groundStation)).setter(ListContactsRequest.setter(Builder::groundStation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStation").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListContactsRequest.getter(ListContactsRequest::maxResults)).setter(ListContactsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("missionProfileArn").getter(ListContactsRequest.getter(ListContactsRequest::missionProfileArn)).setter(ListContactsRequest.setter(Builder::missionProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListContactsRequest.getter(ListContactsRequest::nextToken)).setter(ListContactsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("satelliteArn").getter(ListContactsRequest.getter(ListContactsRequest::satelliteArn)).setter(ListContactsRequest.setter(Builder::satelliteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ListContactsRequest.getter(ListContactsRequest::startTime)).setter(ListContactsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<List<String>> STATUS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statusList").getter(ListContactsRequest.getter(ListContactsRequest::statusListAsStrings)).setter(ListContactsRequest.setter(Builder::statusListWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, GROUND_STATION_FIELD, MAX_RESULTS_FIELD, MISSION_PROFILE_ARN_FIELD, NEXT_TOKEN_FIELD, SATELLITE_ARN_FIELD, START_TIME_FIELD, STATUS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("endTime", END_TIME_FIELD);
            this.put("groundStation", GROUND_STATION_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("missionProfileArn", MISSION_PROFILE_ARN_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("satelliteArn", SATELLITE_ARN_FIELD);
            this.put("startTime", START_TIME_FIELD);
            this.put("statusList", STATUS_LIST_FIELD);
        }
    });
    private final Instant endTime;
    private final String groundStation;
    private final Integer maxResults;
    private final String missionProfileArn;
    private final String nextToken;
    private final String satelliteArn;
    private final Instant startTime;
    private final List<String> statusList;

    private ListContactsRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.groundStation = builder.groundStation;
        this.maxResults = builder.maxResults;
        this.missionProfileArn = builder.missionProfileArn;
        this.nextToken = builder.nextToken;
        this.satelliteArn = builder.satelliteArn;
        this.startTime = builder.startTime;
        this.statusList = builder.statusList;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String groundStation() {
        return this.groundStation;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String missionProfileArn() {
        return this.missionProfileArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String satelliteArn() {
        return this.satelliteArn;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final List<ContactStatus> statusList() {
        return StatusListCopier.copyStringToEnum(this.statusList);
    }

    public final boolean hasStatusList() {
        return this.statusList != null && !(this.statusList instanceof SdkAutoConstructList);
    }

    public final List<String> statusListAsStrings() {
        return this.statusList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.groundStation());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusList() ? this.statusListAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactsRequest)) {
            return false;
        }
        ListContactsRequest other = (ListContactsRequest)((Object)obj);
        return Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.groundStation(), other.groundStation()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.missionProfileArn(), other.missionProfileArn()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.satelliteArn(), other.satelliteArn()) && Objects.equals(this.startTime(), other.startTime()) && this.hasStatusList() == other.hasStatusList() && Objects.equals(this.statusListAsStrings(), other.statusListAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListContactsRequest").add("EndTime", (Object)this.endTime()).add("GroundStation", (Object)this.groundStation()).add("MaxResults", (Object)this.maxResults()).add("MissionProfileArn", (Object)this.missionProfileArn()).add("NextToken", (Object)this.nextToken()).add("SatelliteArn", (Object)this.satelliteArn()).add("StartTime", (Object)this.startTime()).add("StatusList", this.hasStatusList() ? this.statusListAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "groundStation": {
                return Optional.ofNullable(clazz.cast(this.groundStation()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "missionProfileArn": {
                return Optional.ofNullable(clazz.cast(this.missionProfileArn()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "satelliteArn": {
                return Optional.ofNullable(clazz.cast(this.satelliteArn()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "statusList": {
                return Optional.ofNullable(clazz.cast(this.statusListAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListContactsRequest, T> g) {
        return obj -> g.apply((ListContactsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private Instant endTime;
        private String groundStation;
        private Integer maxResults;
        private String missionProfileArn;
        private String nextToken;
        private String satelliteArn;
        private Instant startTime;
        private List<String> statusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactsRequest model) {
            super(model);
            this.endTime(model.endTime);
            this.groundStation(model.groundStation);
            this.maxResults(model.maxResults);
            this.missionProfileArn(model.missionProfileArn);
            this.nextToken(model.nextToken);
            this.satelliteArn(model.satelliteArn);
            this.startTime(model.startTime);
            this.statusListWithStrings(model.statusList);
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getGroundStation() {
            return this.groundStation;
        }

        public final void setGroundStation(String groundStation) {
            this.groundStation = groundStation;
        }

        @Override
        public final Builder groundStation(String groundStation) {
            this.groundStation = groundStation;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getMissionProfileArn() {
            return this.missionProfileArn;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSatelliteArn() {
            return this.satelliteArn;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Collection<String> getStatusList() {
            if (this.statusList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusList;
        }

        public final void setStatusList(Collection<String> statusList) {
            this.statusList = StatusListCopier.copy(statusList);
        }

        @Override
        public final Builder statusListWithStrings(Collection<String> statusList) {
            this.statusList = StatusListCopier.copy(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusListWithStrings(String ... statusList) {
            this.statusListWithStrings(Arrays.asList(statusList));
            return this;
        }

        @Override
        public final Builder statusList(Collection<ContactStatus> statusList) {
            this.statusList = StatusListCopier.copyEnumToString(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusList(ContactStatus ... statusList) {
            this.statusList(Arrays.asList(statusList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListContactsRequest build() {
            return new ListContactsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContactsRequest> {
        public Builder endTime(Instant var1);

        public Builder groundStation(String var1);

        public Builder maxResults(Integer var1);

        public Builder missionProfileArn(String var1);

        public Builder nextToken(String var1);

        public Builder satelliteArn(String var1);

        public Builder startTime(Instant var1);

        public Builder statusListWithStrings(Collection<String> var1);

        public Builder statusListWithStrings(String ... var1);

        public Builder statusList(Collection<ContactStatus> var1);

        public Builder statusList(ContactStatus ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

