/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.EphemerisDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EphemerisTypeDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EphemerisTypeDescription> {
    private static final SdkField<EphemerisDescription> OEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oem").getter(EphemerisTypeDescription.getter(EphemerisTypeDescription::oem)).setter(EphemerisTypeDescription.setter(Builder::oem)).constructor(EphemerisDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oem").build()}).build();
    private static final SdkField<EphemerisDescription> TLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tle").getter(EphemerisTypeDescription.getter(EphemerisTypeDescription::tle)).setter(EphemerisTypeDescription.setter(Builder::tle)).constructor(EphemerisDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OEM_FIELD, TLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("oem", OEM_FIELD);
            this.put("tle", TLE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final EphemerisDescription oem;
    private final EphemerisDescription tle;
    private final Type type;

    private EphemerisTypeDescription(BuilderImpl builder) {
        this.oem = builder.oem;
        this.tle = builder.tle;
        this.type = builder.type;
    }

    public final EphemerisDescription oem() {
        return this.oem;
    }

    public final EphemerisDescription tle() {
        return this.tle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.oem());
        hashCode = 31 * hashCode + Objects.hashCode(this.tle());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EphemerisTypeDescription)) {
            return false;
        }
        EphemerisTypeDescription other = (EphemerisTypeDescription)obj;
        return Objects.equals(this.oem(), other.oem()) && Objects.equals(this.tle(), other.tle());
    }

    public final String toString() {
        return ToString.builder((String)"EphemerisTypeDescription").add("Oem", (Object)this.oem()).add("Tle", (Object)this.tle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "oem": {
                return Optional.ofNullable(clazz.cast(this.oem()));
            }
            case "tle": {
                return Optional.ofNullable(clazz.cast(this.tle()));
            }
        }
        return Optional.empty();
    }

    public static EphemerisTypeDescription fromOem(EphemerisDescription oem) {
        return (EphemerisTypeDescription)EphemerisTypeDescription.builder().oem(oem).build();
    }

    public static EphemerisTypeDescription fromOem(Consumer<EphemerisDescription.Builder> oem) {
        EphemerisDescription.Builder builder = EphemerisDescription.builder();
        oem.accept(builder);
        return EphemerisTypeDescription.fromOem((EphemerisDescription)builder.build());
    }

    public static EphemerisTypeDescription fromTle(EphemerisDescription tle) {
        return (EphemerisTypeDescription)EphemerisTypeDescription.builder().tle(tle).build();
    }

    public static EphemerisTypeDescription fromTle(Consumer<EphemerisDescription.Builder> tle) {
        EphemerisDescription.Builder builder = EphemerisDescription.builder();
        tle.accept(builder);
        return EphemerisTypeDescription.fromTle((EphemerisDescription)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EphemerisTypeDescription, T> g) {
        return obj -> g.apply((EphemerisTypeDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        OEM,
        TLE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EphemerisDescription oem;
        private EphemerisDescription tle;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EphemerisTypeDescription model) {
            this.oem(model.oem);
            this.tle(model.tle);
        }

        public final EphemerisDescription.Builder getOem() {
            return this.oem != null ? this.oem.toBuilder() : null;
        }

        public final void setOem(EphemerisDescription.BuilderImpl oem) {
            EphemerisDescription oldValue = this.oem;
            this.oem = oem != null ? oem.build() : null;
            this.handleUnionValueChange(Type.OEM, oldValue, this.oem);
        }

        @Override
        public final Builder oem(EphemerisDescription oem) {
            EphemerisDescription oldValue = this.oem;
            this.oem = oem;
            this.handleUnionValueChange(Type.OEM, oldValue, this.oem);
            return this;
        }

        public final EphemerisDescription.Builder getTle() {
            return this.tle != null ? this.tle.toBuilder() : null;
        }

        public final void setTle(EphemerisDescription.BuilderImpl tle) {
            EphemerisDescription oldValue = this.tle;
            this.tle = tle != null ? tle.build() : null;
            this.handleUnionValueChange(Type.TLE, oldValue, this.tle);
        }

        @Override
        public final Builder tle(EphemerisDescription tle) {
            EphemerisDescription oldValue = this.tle;
            this.tle = tle;
            this.handleUnionValueChange(Type.TLE, oldValue, this.tle);
            return this;
        }

        public EphemerisTypeDescription build() {
            return new EphemerisTypeDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EphemerisTypeDescription> {
        public Builder oem(EphemerisDescription var1);

        default public Builder oem(Consumer<EphemerisDescription.Builder> oem) {
            return this.oem((EphemerisDescription)((EphemerisDescription.Builder)EphemerisDescription.builder().applyMutation(oem)).build());
        }

        public Builder tle(EphemerisDescription var1);

        default public Builder tle(Consumer<EphemerisDescription.Builder> tle) {
            return this.tle((EphemerisDescription)((EphemerisDescription.Builder)EphemerisDescription.builder().applyMutation(tle)).build());
        }
    }
}

