/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.AgentStatus;
import software.amazon.awssdk.services.groundstation.model.SignatureMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregateStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregateStatus> {
    private static final SdkField<Map<String, Boolean>> SIGNATURE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("signatureMap").getter(AggregateStatus.getter(AggregateStatus::signatureMap)).setter(AggregateStatus.setter(Builder::signatureMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AggregateStatus.getter(AggregateStatus::statusAsString)).setter(AggregateStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNATURE_MAP_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("signatureMap", SIGNATURE_MAP_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, Boolean> signatureMap;
    private final String status;

    private AggregateStatus(BuilderImpl builder) {
        this.signatureMap = builder.signatureMap;
        this.status = builder.status;
    }

    public final boolean hasSignatureMap() {
        return this.signatureMap != null && !(this.signatureMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, Boolean> signatureMap() {
        return this.signatureMap;
    }

    public final AgentStatus status() {
        return AgentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignatureMap() ? this.signatureMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateStatus)) {
            return false;
        }
        AggregateStatus other = (AggregateStatus)obj;
        return this.hasSignatureMap() == other.hasSignatureMap() && Objects.equals(this.signatureMap(), other.signatureMap()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AggregateStatus").add("SignatureMap", this.hasSignatureMap() ? this.signatureMap() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signatureMap": {
                return Optional.ofNullable(clazz.cast(this.signatureMap()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AggregateStatus, T> g) {
        return obj -> g.apply((AggregateStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Boolean> signatureMap = DefaultSdkAutoConstructMap.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateStatus model) {
            this.signatureMap(model.signatureMap);
            this.status(model.status);
        }

        public final Map<String, Boolean> getSignatureMap() {
            if (this.signatureMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.signatureMap;
        }

        public final void setSignatureMap(Map<String, Boolean> signatureMap) {
            this.signatureMap = SignatureMapCopier.copy(signatureMap);
        }

        @Override
        public final Builder signatureMap(Map<String, Boolean> signatureMap) {
            this.signatureMap = SignatureMapCopier.copy(signatureMap);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public AggregateStatus build() {
            return new AggregateStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregateStatus> {
        public Builder signatureMap(Map<String, Boolean> var1);

        public Builder status(String var1);

        public Builder status(AgentStatus var1);
    }
}

