/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Response;
import software.amazon.awssdk.services.greengrassv2.model.InstalledComponent;
import software.amazon.awssdk.services.greengrassv2.model.InstalledComponentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInstalledComponentsResponse
extends GreengrassV2Response
implements ToCopyableBuilder<Builder, ListInstalledComponentsResponse> {
    private static final SdkField<List<InstalledComponent>> INSTALLED_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("installedComponents").getter(ListInstalledComponentsResponse.getter(ListInstalledComponentsResponse::installedComponents)).setter(ListInstalledComponentsResponse.setter(Builder::installedComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("installedComponents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstalledComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListInstalledComponentsResponse.getter(ListInstalledComponentsResponse::nextToken)).setter(ListInstalledComponentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTALLED_COMPONENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("installedComponents", INSTALLED_COMPONENTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<InstalledComponent> installedComponents;
    private final String nextToken;

    private ListInstalledComponentsResponse(BuilderImpl builder) {
        super(builder);
        this.installedComponents = builder.installedComponents;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstalledComponents() {
        return this.installedComponents != null && !(this.installedComponents instanceof SdkAutoConstructList);
    }

    public final List<InstalledComponent> installedComponents() {
        return this.installedComponents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstalledComponents() ? this.installedComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstalledComponentsResponse)) {
            return false;
        }
        ListInstalledComponentsResponse other = (ListInstalledComponentsResponse)((Object)obj);
        return this.hasInstalledComponents() == other.hasInstalledComponents() && Objects.equals(this.installedComponents(), other.installedComponents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInstalledComponentsResponse").add("InstalledComponents", this.hasInstalledComponents() ? this.installedComponents() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "installedComponents": {
                return Optional.ofNullable(clazz.cast(this.installedComponents()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListInstalledComponentsResponse, T> g) {
        return obj -> g.apply((ListInstalledComponentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Response.BuilderImpl
    implements Builder {
        private List<InstalledComponent> installedComponents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstalledComponentsResponse model) {
            super(model);
            this.installedComponents(model.installedComponents);
            this.nextToken(model.nextToken);
        }

        public final List<InstalledComponent.Builder> getInstalledComponents() {
            List<InstalledComponent.Builder> result = InstalledComponentListCopier.copyToBuilder(this.installedComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstalledComponents(Collection<InstalledComponent.BuilderImpl> installedComponents) {
            this.installedComponents = InstalledComponentListCopier.copyFromBuilder(installedComponents);
        }

        @Override
        public final Builder installedComponents(Collection<InstalledComponent> installedComponents) {
            this.installedComponents = InstalledComponentListCopier.copy(installedComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder installedComponents(InstalledComponent ... installedComponents) {
            this.installedComponents(Arrays.asList(installedComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder installedComponents(Consumer<InstalledComponent.Builder> ... installedComponents) {
            this.installedComponents(Stream.of(installedComponents).map(c -> (InstalledComponent)((InstalledComponent.Builder)InstalledComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInstalledComponentsResponse build() {
            return new ListInstalledComponentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GreengrassV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInstalledComponentsResponse> {
        public Builder installedComponents(Collection<InstalledComponent> var1);

        public Builder installedComponents(InstalledComponent ... var1);

        public Builder installedComponents(Consumer<InstalledComponent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

