/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServiceRoleForAccountResponse
extends GreengrassV2Response
implements ToCopyableBuilder<Builder, GetServiceRoleForAccountResponse> {
    private static final SdkField<String> ASSOCIATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associatedAt").getter(GetServiceRoleForAccountResponse.getter(GetServiceRoleForAccountResponse::associatedAt)).setter(GetServiceRoleForAccountResponse.setter(Builder::associatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedAt").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetServiceRoleForAccountResponse.getter(GetServiceRoleForAccountResponse::roleArn)).setter(GetServiceRoleForAccountResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_AT_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AssociatedAt", ASSOCIATED_AT_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
        }
    });
    private final String associatedAt;
    private final String roleArn;

    private GetServiceRoleForAccountResponse(BuilderImpl builder) {
        super(builder);
        this.associatedAt = builder.associatedAt;
        this.roleArn = builder.roleArn;
    }

    public final String associatedAt() {
        return this.associatedAt;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceRoleForAccountResponse)) {
            return false;
        }
        GetServiceRoleForAccountResponse other = (GetServiceRoleForAccountResponse)((Object)obj);
        return Objects.equals(this.associatedAt(), other.associatedAt()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetServiceRoleForAccountResponse").add("AssociatedAt", (Object)this.associatedAt()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associatedAt": {
                return Optional.ofNullable(clazz.cast(this.associatedAt()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceRoleForAccountResponse, T> g) {
        return obj -> g.apply((GetServiceRoleForAccountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Response.BuilderImpl
    implements Builder {
        private String associatedAt;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceRoleForAccountResponse model) {
            super(model);
            this.associatedAt(model.associatedAt);
            this.roleArn(model.roleArn);
        }

        public final String getAssociatedAt() {
            return this.associatedAt;
        }

        public final void setAssociatedAt(String associatedAt) {
            this.associatedAt = associatedAt;
        }

        @Override
        public final Builder associatedAt(String associatedAt) {
            this.associatedAt = associatedAt;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public GetServiceRoleForAccountResponse build() {
            return new GetServiceRoleForAccountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GreengrassV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServiceRoleForAccountResponse> {
        public Builder associatedAt(String var1);

        public Builder roleArn(String var1);
    }
}

