/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergOrphanFileDeletionMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergOrphanFileDeletionMetrics> {
    private static final SdkField<Long> NUMBER_OF_ORPHAN_FILES_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfOrphanFilesDeleted").getter(IcebergOrphanFileDeletionMetrics.getter(IcebergOrphanFileDeletionMetrics::numberOfOrphanFilesDeleted)).setter(IcebergOrphanFileDeletionMetrics.setter(Builder::numberOfOrphanFilesDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfOrphanFilesDeleted").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_DPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfDpus").getter(IcebergOrphanFileDeletionMetrics.getter(IcebergOrphanFileDeletionMetrics::numberOfDpus)).setter(IcebergOrphanFileDeletionMetrics.setter(Builder::numberOfDpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDpus").build()}).build();
    private static final SdkField<Double> JOB_DURATION_IN_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("JobDurationInHour").getter(IcebergOrphanFileDeletionMetrics.getter(IcebergOrphanFileDeletionMetrics::jobDurationInHour)).setter(IcebergOrphanFileDeletionMetrics.setter(Builder::jobDurationInHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDurationInHour").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_ORPHAN_FILES_DELETED_FIELD, NUMBER_OF_DPUS_FIELD, JOB_DURATION_IN_HOUR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NumberOfOrphanFilesDeleted", NUMBER_OF_ORPHAN_FILES_DELETED_FIELD);
            this.put("NumberOfDpus", NUMBER_OF_DPUS_FIELD);
            this.put("JobDurationInHour", JOB_DURATION_IN_HOUR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long numberOfOrphanFilesDeleted;
    private final Integer numberOfDpus;
    private final Double jobDurationInHour;

    private IcebergOrphanFileDeletionMetrics(BuilderImpl builder) {
        this.numberOfOrphanFilesDeleted = builder.numberOfOrphanFilesDeleted;
        this.numberOfDpus = builder.numberOfDpus;
        this.jobDurationInHour = builder.jobDurationInHour;
    }

    public final Long numberOfOrphanFilesDeleted() {
        return this.numberOfOrphanFilesDeleted;
    }

    public final Integer numberOfDpus() {
        return this.numberOfDpus;
    }

    public final Double jobDurationInHour() {
        return this.jobDurationInHour;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfOrphanFilesDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDurationInHour());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergOrphanFileDeletionMetrics)) {
            return false;
        }
        IcebergOrphanFileDeletionMetrics other = (IcebergOrphanFileDeletionMetrics)obj;
        return Objects.equals(this.numberOfOrphanFilesDeleted(), other.numberOfOrphanFilesDeleted()) && Objects.equals(this.numberOfDpus(), other.numberOfDpus()) && Objects.equals(this.jobDurationInHour(), other.jobDurationInHour());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergOrphanFileDeletionMetrics").add("NumberOfOrphanFilesDeleted", (Object)this.numberOfOrphanFilesDeleted()).add("NumberOfDpus", (Object)this.numberOfDpus()).add("JobDurationInHour", (Object)this.jobDurationInHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumberOfOrphanFilesDeleted": {
                return Optional.ofNullable(clazz.cast(this.numberOfOrphanFilesDeleted()));
            }
            case "NumberOfDpus": {
                return Optional.ofNullable(clazz.cast(this.numberOfDpus()));
            }
            case "JobDurationInHour": {
                return Optional.ofNullable(clazz.cast(this.jobDurationInHour()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IcebergOrphanFileDeletionMetrics, T> g) {
        return obj -> g.apply((IcebergOrphanFileDeletionMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long numberOfOrphanFilesDeleted;
        private Integer numberOfDpus;
        private Double jobDurationInHour;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergOrphanFileDeletionMetrics model) {
            this.numberOfOrphanFilesDeleted(model.numberOfOrphanFilesDeleted);
            this.numberOfDpus(model.numberOfDpus);
            this.jobDurationInHour(model.jobDurationInHour);
        }

        public final Long getNumberOfOrphanFilesDeleted() {
            return this.numberOfOrphanFilesDeleted;
        }

        public final void setNumberOfOrphanFilesDeleted(Long numberOfOrphanFilesDeleted) {
            this.numberOfOrphanFilesDeleted = numberOfOrphanFilesDeleted;
        }

        @Override
        public final Builder numberOfOrphanFilesDeleted(Long numberOfOrphanFilesDeleted) {
            this.numberOfOrphanFilesDeleted = numberOfOrphanFilesDeleted;
            return this;
        }

        public final Integer getNumberOfDpus() {
            return this.numberOfDpus;
        }

        public final void setNumberOfDpus(Integer numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
        }

        @Override
        public final Builder numberOfDpus(Integer numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
            return this;
        }

        public final Double getJobDurationInHour() {
            return this.jobDurationInHour;
        }

        public final void setJobDurationInHour(Double jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
        }

        @Override
        public final Builder jobDurationInHour(Double jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
            return this;
        }

        public IcebergOrphanFileDeletionMetrics build() {
            return new IcebergOrphanFileDeletionMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergOrphanFileDeletionMetrics> {
        public Builder numberOfOrphanFilesDeleted(Long var1);

        public Builder numberOfDpus(Integer var1);

        public Builder jobDurationInHour(Double var1);
    }
}

