/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateColumnStatisticsData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DateColumnStatisticsData> {
    private static final SdkField<Instant> MINIMUM_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("MinimumValue").getter(DateColumnStatisticsData.getter(DateColumnStatisticsData::minimumValue)).setter(DateColumnStatisticsData.setter(Builder::minimumValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumValue").build()}).build();
    private static final SdkField<Instant> MAXIMUM_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("MaximumValue").getter(DateColumnStatisticsData.getter(DateColumnStatisticsData::maximumValue)).setter(DateColumnStatisticsData.setter(Builder::maximumValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumValue").build()}).build();
    private static final SdkField<Long> NUMBER_OF_NULLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfNulls").getter(DateColumnStatisticsData.getter(DateColumnStatisticsData::numberOfNulls)).setter(DateColumnStatisticsData.setter(Builder::numberOfNulls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNulls").build()}).build();
    private static final SdkField<Long> NUMBER_OF_DISTINCT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfDistinctValues").getter(DateColumnStatisticsData.getter(DateColumnStatisticsData::numberOfDistinctValues)).setter(DateColumnStatisticsData.setter(Builder::numberOfDistinctValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDistinctValues").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_VALUE_FIELD, MAXIMUM_VALUE_FIELD, NUMBER_OF_NULLS_FIELD, NUMBER_OF_DISTINCT_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MinimumValue", MINIMUM_VALUE_FIELD);
            this.put("MaximumValue", MAXIMUM_VALUE_FIELD);
            this.put("NumberOfNulls", NUMBER_OF_NULLS_FIELD);
            this.put("NumberOfDistinctValues", NUMBER_OF_DISTINCT_VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant minimumValue;
    private final Instant maximumValue;
    private final Long numberOfNulls;
    private final Long numberOfDistinctValues;

    private DateColumnStatisticsData(BuilderImpl builder) {
        this.minimumValue = builder.minimumValue;
        this.maximumValue = builder.maximumValue;
        this.numberOfNulls = builder.numberOfNulls;
        this.numberOfDistinctValues = builder.numberOfDistinctValues;
    }

    public final Instant minimumValue() {
        return this.minimumValue;
    }

    public final Instant maximumValue() {
        return this.maximumValue;
    }

    public final Long numberOfNulls() {
        return this.numberOfNulls;
    }

    public final Long numberOfDistinctValues() {
        return this.numberOfDistinctValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNulls());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDistinctValues());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateColumnStatisticsData)) {
            return false;
        }
        DateColumnStatisticsData other = (DateColumnStatisticsData)obj;
        return Objects.equals(this.minimumValue(), other.minimumValue()) && Objects.equals(this.maximumValue(), other.maximumValue()) && Objects.equals(this.numberOfNulls(), other.numberOfNulls()) && Objects.equals(this.numberOfDistinctValues(), other.numberOfDistinctValues());
    }

    public final String toString() {
        return ToString.builder((String)"DateColumnStatisticsData").add("MinimumValue", (Object)this.minimumValue()).add("MaximumValue", (Object)this.maximumValue()).add("NumberOfNulls", (Object)this.numberOfNulls()).add("NumberOfDistinctValues", (Object)this.numberOfDistinctValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumValue": {
                return Optional.ofNullable(clazz.cast(this.minimumValue()));
            }
            case "MaximumValue": {
                return Optional.ofNullable(clazz.cast(this.maximumValue()));
            }
            case "NumberOfNulls": {
                return Optional.ofNullable(clazz.cast(this.numberOfNulls()));
            }
            case "NumberOfDistinctValues": {
                return Optional.ofNullable(clazz.cast(this.numberOfDistinctValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DateColumnStatisticsData, T> g) {
        return obj -> g.apply((DateColumnStatisticsData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant minimumValue;
        private Instant maximumValue;
        private Long numberOfNulls;
        private Long numberOfDistinctValues;

        private BuilderImpl() {
        }

        private BuilderImpl(DateColumnStatisticsData model) {
            this.minimumValue(model.minimumValue);
            this.maximumValue(model.maximumValue);
            this.numberOfNulls(model.numberOfNulls);
            this.numberOfDistinctValues(model.numberOfDistinctValues);
        }

        public final Instant getMinimumValue() {
            return this.minimumValue;
        }

        public final void setMinimumValue(Instant minimumValue) {
            this.minimumValue = minimumValue;
        }

        @Override
        public final Builder minimumValue(Instant minimumValue) {
            this.minimumValue = minimumValue;
            return this;
        }

        public final Instant getMaximumValue() {
            return this.maximumValue;
        }

        public final void setMaximumValue(Instant maximumValue) {
            this.maximumValue = maximumValue;
        }

        @Override
        public final Builder maximumValue(Instant maximumValue) {
            this.maximumValue = maximumValue;
            return this;
        }

        public final Long getNumberOfNulls() {
            return this.numberOfNulls;
        }

        public final void setNumberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
        }

        @Override
        public final Builder numberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
            return this;
        }

        public final Long getNumberOfDistinctValues() {
            return this.numberOfDistinctValues;
        }

        public final void setNumberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
        }

        @Override
        public final Builder numberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
            return this;
        }

        public DateColumnStatisticsData build() {
            return new DateColumnStatisticsData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DateColumnStatisticsData> {
        public Builder minimumValue(Instant var1);

        public Builder maximumValue(Instant var1);

        public Builder numberOfNulls(Long var1);

        public Builder numberOfDistinctValues(Long var1);
    }
}

