/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.FleetUtilization;
import software.amazon.awssdk.services.gamelift.model.FleetUtilizationListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetUtilizationResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeFleetUtilizationResponse> {
    private static final SdkField<List<FleetUtilization>> FLEET_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FleetUtilization").getter(DescribeFleetUtilizationResponse.getter(DescribeFleetUtilizationResponse::fleetUtilization)).setter(DescribeFleetUtilizationResponse.setter(Builder::fleetUtilization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetUtilization").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetUtilization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFleetUtilizationResponse.getter(DescribeFleetUtilizationResponse::nextToken)).setter(DescribeFleetUtilizationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_UTILIZATION_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FleetUtilization", FLEET_UTILIZATION_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<FleetUtilization> fleetUtilization;
    private final String nextToken;

    private DescribeFleetUtilizationResponse(BuilderImpl builder) {
        super(builder);
        this.fleetUtilization = builder.fleetUtilization;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFleetUtilization() {
        return this.fleetUtilization != null && !(this.fleetUtilization instanceof SdkAutoConstructList);
    }

    public final List<FleetUtilization> fleetUtilization() {
        return this.fleetUtilization;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFleetUtilization() ? this.fleetUtilization() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetUtilizationResponse)) {
            return false;
        }
        DescribeFleetUtilizationResponse other = (DescribeFleetUtilizationResponse)((Object)obj);
        return this.hasFleetUtilization() == other.hasFleetUtilization() && Objects.equals(this.fleetUtilization(), other.fleetUtilization()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFleetUtilizationResponse").add("FleetUtilization", this.hasFleetUtilization() ? this.fleetUtilization() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetUtilization": {
                return Optional.ofNullable(clazz.cast(this.fleetUtilization()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetUtilizationResponse, T> g) {
        return obj -> g.apply((DescribeFleetUtilizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<FleetUtilization> fleetUtilization = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetUtilizationResponse model) {
            super(model);
            this.fleetUtilization(model.fleetUtilization);
            this.nextToken(model.nextToken);
        }

        public final List<FleetUtilization.Builder> getFleetUtilization() {
            List<FleetUtilization.Builder> result = FleetUtilizationListCopier.copyToBuilder(this.fleetUtilization);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFleetUtilization(Collection<FleetUtilization.BuilderImpl> fleetUtilization) {
            this.fleetUtilization = FleetUtilizationListCopier.copyFromBuilder(fleetUtilization);
        }

        @Override
        public final Builder fleetUtilization(Collection<FleetUtilization> fleetUtilization) {
            this.fleetUtilization = FleetUtilizationListCopier.copy(fleetUtilization);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetUtilization(FleetUtilization ... fleetUtilization) {
            this.fleetUtilization(Arrays.asList(fleetUtilization));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetUtilization(Consumer<FleetUtilization.Builder> ... fleetUtilization) {
            this.fleetUtilization(Stream.of(fleetUtilization).map(c -> (FleetUtilization)((FleetUtilization.Builder)FleetUtilization.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFleetUtilizationResponse build() {
            return new DescribeFleetUtilizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetUtilizationResponse> {
        public Builder fleetUtilization(Collection<FleetUtilization> var1);

        public Builder fleetUtilization(FleetUtilization ... var1);

        public Builder fleetUtilization(Consumer<FleetUtilization.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

