/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.frauddetector.model.Entity;
import software.amazon.awssdk.services.frauddetector.model.EventVariableMapCopier;
import software.amazon.awssdk.services.frauddetector.model.ExternalModelEndpointDataBlobMapCopier;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.ModelEndpointDataBlob;
import software.amazon.awssdk.services.frauddetector.model._listOfEntitiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEventPredictionRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, GetEventPredictionRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorId").getter(GetEventPredictionRequest.getter(GetEventPredictionRequest::detectorId)).setter(GetEventPredictionRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorVersionId").getter(GetEventPredictionRequest.getter(GetEventPredictionRequest::detectorVersionId)).setter(GetEventPredictionRequest.setter(Builder::detectorVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(GetEventPredictionRequest.getter(GetEventPredictionRequest::eventId)).setter(GetEventPredictionRequest.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTypeName").getter(GetEventPredictionRequest.getter(GetEventPredictionRequest::eventTypeName)).setter(GetEventPredictionRequest.setter(Builder::eventTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()}).build();
    private static final SdkField<List<Entity>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entities").getter(GetEventPredictionRequest.getter(GetEventPredictionRequest::entities)).setter(GetEventPredictionRequest.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Entity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVENT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTimestamp").getter(GetEventPredictionRequest.getter(GetEventPredictionRequest::eventTimestamp)).setter(GetEventPredictionRequest.setter(Builder::eventTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()}).build();
    private static final SdkField<Map<String, String>> EVENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("eventVariables").getter(GetEventPredictionRequest.getter(GetEventPredictionRequest::eventVariables)).setter(GetEventPredictionRequest.setter(Builder::eventVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ModelEndpointDataBlob>> EXTERNAL_MODEL_ENDPOINT_DATA_BLOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("externalModelEndpointDataBlobs").getter(GetEventPredictionRequest.getter(GetEventPredictionRequest::externalModelEndpointDataBlobs)).setter(GetEventPredictionRequest.setter(Builder::externalModelEndpointDataBlobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalModelEndpointDataBlobs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelEndpointDataBlob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, DETECTOR_VERSION_ID_FIELD, EVENT_ID_FIELD, EVENT_TYPE_NAME_FIELD, ENTITIES_FIELD, EVENT_TIMESTAMP_FIELD, EVENT_VARIABLES_FIELD, EXTERNAL_MODEL_ENDPOINT_DATA_BLOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("detectorId", DETECTOR_ID_FIELD);
            this.put("detectorVersionId", DETECTOR_VERSION_ID_FIELD);
            this.put("eventId", EVENT_ID_FIELD);
            this.put("eventTypeName", EVENT_TYPE_NAME_FIELD);
            this.put("entities", ENTITIES_FIELD);
            this.put("eventTimestamp", EVENT_TIMESTAMP_FIELD);
            this.put("eventVariables", EVENT_VARIABLES_FIELD);
            this.put("externalModelEndpointDataBlobs", EXTERNAL_MODEL_ENDPOINT_DATA_BLOBS_FIELD);
        }
    });
    private final String detectorId;
    private final String detectorVersionId;
    private final String eventId;
    private final String eventTypeName;
    private final List<Entity> entities;
    private final String eventTimestamp;
    private final Map<String, String> eventVariables;
    private final Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs;

    private GetEventPredictionRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.eventId = builder.eventId;
        this.eventTypeName = builder.eventTypeName;
        this.entities = builder.entities;
        this.eventTimestamp = builder.eventTimestamp;
        this.eventVariables = builder.eventVariables;
        this.externalModelEndpointDataBlobs = builder.externalModelEndpointDataBlobs;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String detectorVersionId() {
        return this.detectorVersionId;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String eventTypeName() {
        return this.eventTypeName;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<Entity> entities() {
        return this.entities;
    }

    public final String eventTimestamp() {
        return this.eventTimestamp;
    }

    public final boolean hasEventVariables() {
        return this.eventVariables != null && !(this.eventVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> eventVariables() {
        return this.eventVariables;
    }

    public final boolean hasExternalModelEndpointDataBlobs() {
        return this.externalModelEndpointDataBlobs != null && !(this.externalModelEndpointDataBlobs instanceof SdkAutoConstructMap);
    }

    public final Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs() {
        return this.externalModelEndpointDataBlobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventVariables() ? this.eventVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExternalModelEndpointDataBlobs() ? this.externalModelEndpointDataBlobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventPredictionRequest)) {
            return false;
        }
        GetEventPredictionRequest other = (GetEventPredictionRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.detectorVersionId(), other.detectorVersionId()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventTypeName(), other.eventTypeName()) && this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities()) && Objects.equals(this.eventTimestamp(), other.eventTimestamp()) && this.hasEventVariables() == other.hasEventVariables() && Objects.equals(this.eventVariables(), other.eventVariables()) && this.hasExternalModelEndpointDataBlobs() == other.hasExternalModelEndpointDataBlobs() && Objects.equals(this.externalModelEndpointDataBlobs(), other.externalModelEndpointDataBlobs());
    }

    public final String toString() {
        return ToString.builder((String)"GetEventPredictionRequest").add("DetectorId", (Object)this.detectorId()).add("DetectorVersionId", (Object)this.detectorVersionId()).add("EventId", (Object)this.eventId()).add("EventTypeName", (Object)this.eventTypeName()).add("Entities", (Object)(this.entities() == null ? null : "*** Sensitive Data Redacted ***")).add("EventTimestamp", (Object)this.eventTimestamp()).add("EventVariables", (Object)(this.eventVariables() == null ? null : "*** Sensitive Data Redacted ***")).add("ExternalModelEndpointDataBlobs", (Object)(this.externalModelEndpointDataBlobs() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "detectorVersionId": {
                return Optional.ofNullable(clazz.cast(this.detectorVersionId()));
            }
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventTypeName": {
                return Optional.ofNullable(clazz.cast(this.eventTypeName()));
            }
            case "entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
            case "eventTimestamp": {
                return Optional.ofNullable(clazz.cast(this.eventTimestamp()));
            }
            case "eventVariables": {
                return Optional.ofNullable(clazz.cast(this.eventVariables()));
            }
            case "externalModelEndpointDataBlobs": {
                return Optional.ofNullable(clazz.cast(this.externalModelEndpointDataBlobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetEventPredictionRequest, T> g) {
        return obj -> g.apply((GetEventPredictionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String detectorVersionId;
        private String eventId;
        private String eventTypeName;
        private List<Entity> entities = DefaultSdkAutoConstructList.getInstance();
        private String eventTimestamp;
        private Map<String, String> eventVariables = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventPredictionRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.detectorVersionId(model.detectorVersionId);
            this.eventId(model.eventId);
            this.eventTypeName(model.eventTypeName);
            this.entities(model.entities);
            this.eventTimestamp(model.eventTimestamp);
            this.eventVariables(model.eventVariables);
            this.externalModelEndpointDataBlobs(model.externalModelEndpointDataBlobs);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDetectorVersionId() {
            return this.detectorVersionId;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        @Override
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventTypeName() {
            return this.eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final List<Entity.Builder> getEntities() {
            List<Entity.Builder> result = _listOfEntitiesCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<Entity.BuilderImpl> entities) {
            this.entities = _listOfEntitiesCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<Entity> entities) {
            this.entities = _listOfEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Entity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<Entity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (Entity)((Entity.Builder)Entity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEventTimestamp() {
            return this.eventTimestamp;
        }

        public final void setEventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final Map<String, String> getEventVariables() {
            if (this.eventVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.eventVariables;
        }

        public final void setEventVariables(Map<String, String> eventVariables) {
            this.eventVariables = EventVariableMapCopier.copy(eventVariables);
        }

        @Override
        public final Builder eventVariables(Map<String, String> eventVariables) {
            this.eventVariables = EventVariableMapCopier.copy(eventVariables);
            return this;
        }

        public final Map<String, ModelEndpointDataBlob.Builder> getExternalModelEndpointDataBlobs() {
            Map<String, ModelEndpointDataBlob.Builder> result = ExternalModelEndpointDataBlobMapCopier.copyToBuilder(this.externalModelEndpointDataBlobs);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExternalModelEndpointDataBlobs(Map<String, ModelEndpointDataBlob.BuilderImpl> externalModelEndpointDataBlobs) {
            this.externalModelEndpointDataBlobs = ExternalModelEndpointDataBlobMapCopier.copyFromBuilder(externalModelEndpointDataBlobs);
        }

        @Override
        public final Builder externalModelEndpointDataBlobs(Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs) {
            this.externalModelEndpointDataBlobs = ExternalModelEndpointDataBlobMapCopier.copy(externalModelEndpointDataBlobs);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEventPredictionRequest build() {
            return new GetEventPredictionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEventPredictionRequest> {
        public Builder detectorId(String var1);

        public Builder detectorVersionId(String var1);

        public Builder eventId(String var1);

        public Builder eventTypeName(String var1);

        public Builder entities(Collection<Entity> var1);

        public Builder entities(Entity ... var1);

        public Builder entities(Consumer<Entity.Builder> ... var1);

        public Builder eventTimestamp(String var1);

        public Builder eventVariables(Map<String, String> var1);

        public Builder externalModelEndpointDataBlobs(Map<String, ModelEndpointDataBlob> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

