/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.ListOfNonEmptyStringsWithoutWhitespaceCopier;
import software.amazon.awssdk.services.firehose.model.PartitionSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationTableConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationTableConfiguration> {
    private static final SdkField<String> DESTINATION_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationTableName").getter(DestinationTableConfiguration.getter(DestinationTableConfiguration::destinationTableName)).setter(DestinationTableConfiguration.setter(Builder::destinationTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTableName").build()}).build();
    private static final SdkField<String> DESTINATION_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationDatabaseName").getter(DestinationTableConfiguration.getter(DestinationTableConfiguration::destinationDatabaseName)).setter(DestinationTableConfiguration.setter(Builder::destinationDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDatabaseName").build()}).build();
    private static final SdkField<List<String>> UNIQUE_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UniqueKeys").getter(DestinationTableConfiguration.getter(DestinationTableConfiguration::uniqueKeys)).setter(DestinationTableConfiguration.setter(Builder::uniqueKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PartitionSpec> PARTITION_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PartitionSpec").getter(DestinationTableConfiguration.getter(DestinationTableConfiguration::partitionSpec)).setter(DestinationTableConfiguration.setter(Builder::partitionSpec)).constructor(PartitionSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionSpec").build()}).build();
    private static final SdkField<String> S3_ERROR_OUTPUT_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3ErrorOutputPrefix").getter(DestinationTableConfiguration.getter(DestinationTableConfiguration::s3ErrorOutputPrefix)).setter(DestinationTableConfiguration.setter(Builder::s3ErrorOutputPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ErrorOutputPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_TABLE_NAME_FIELD, DESTINATION_DATABASE_NAME_FIELD, UNIQUE_KEYS_FIELD, PARTITION_SPEC_FIELD, S3_ERROR_OUTPUT_PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DestinationTableName", DESTINATION_TABLE_NAME_FIELD);
            this.put("DestinationDatabaseName", DESTINATION_DATABASE_NAME_FIELD);
            this.put("UniqueKeys", UNIQUE_KEYS_FIELD);
            this.put("PartitionSpec", PARTITION_SPEC_FIELD);
            this.put("S3ErrorOutputPrefix", S3_ERROR_OUTPUT_PREFIX_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String destinationTableName;
    private final String destinationDatabaseName;
    private final List<String> uniqueKeys;
    private final PartitionSpec partitionSpec;
    private final String s3ErrorOutputPrefix;

    private DestinationTableConfiguration(BuilderImpl builder) {
        this.destinationTableName = builder.destinationTableName;
        this.destinationDatabaseName = builder.destinationDatabaseName;
        this.uniqueKeys = builder.uniqueKeys;
        this.partitionSpec = builder.partitionSpec;
        this.s3ErrorOutputPrefix = builder.s3ErrorOutputPrefix;
    }

    public final String destinationTableName() {
        return this.destinationTableName;
    }

    public final String destinationDatabaseName() {
        return this.destinationDatabaseName;
    }

    public final boolean hasUniqueKeys() {
        return this.uniqueKeys != null && !(this.uniqueKeys instanceof SdkAutoConstructList);
    }

    public final List<String> uniqueKeys() {
        return this.uniqueKeys;
    }

    public final PartitionSpec partitionSpec() {
        return this.partitionSpec;
    }

    public final String s3ErrorOutputPrefix() {
        return this.s3ErrorOutputPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUniqueKeys() ? this.uniqueKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ErrorOutputPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationTableConfiguration)) {
            return false;
        }
        DestinationTableConfiguration other = (DestinationTableConfiguration)obj;
        return Objects.equals(this.destinationTableName(), other.destinationTableName()) && Objects.equals(this.destinationDatabaseName(), other.destinationDatabaseName()) && this.hasUniqueKeys() == other.hasUniqueKeys() && Objects.equals(this.uniqueKeys(), other.uniqueKeys()) && Objects.equals(this.partitionSpec(), other.partitionSpec()) && Objects.equals(this.s3ErrorOutputPrefix(), other.s3ErrorOutputPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"DestinationTableConfiguration").add("DestinationTableName", (Object)this.destinationTableName()).add("DestinationDatabaseName", (Object)this.destinationDatabaseName()).add("UniqueKeys", this.hasUniqueKeys() ? this.uniqueKeys() : null).add("PartitionSpec", (Object)this.partitionSpec()).add("S3ErrorOutputPrefix", (Object)this.s3ErrorOutputPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationTableName": {
                return Optional.ofNullable(clazz.cast(this.destinationTableName()));
            }
            case "DestinationDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.destinationDatabaseName()));
            }
            case "UniqueKeys": {
                return Optional.ofNullable(clazz.cast(this.uniqueKeys()));
            }
            case "PartitionSpec": {
                return Optional.ofNullable(clazz.cast(this.partitionSpec()));
            }
            case "S3ErrorOutputPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3ErrorOutputPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DestinationTableConfiguration, T> g) {
        return obj -> g.apply((DestinationTableConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationTableName;
        private String destinationDatabaseName;
        private List<String> uniqueKeys = DefaultSdkAutoConstructList.getInstance();
        private PartitionSpec partitionSpec;
        private String s3ErrorOutputPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationTableConfiguration model) {
            this.destinationTableName(model.destinationTableName);
            this.destinationDatabaseName(model.destinationDatabaseName);
            this.uniqueKeys(model.uniqueKeys);
            this.partitionSpec(model.partitionSpec);
            this.s3ErrorOutputPrefix(model.s3ErrorOutputPrefix);
        }

        public final String getDestinationTableName() {
            return this.destinationTableName;
        }

        public final void setDestinationTableName(String destinationTableName) {
            this.destinationTableName = destinationTableName;
        }

        @Override
        public final Builder destinationTableName(String destinationTableName) {
            this.destinationTableName = destinationTableName;
            return this;
        }

        public final String getDestinationDatabaseName() {
            return this.destinationDatabaseName;
        }

        public final void setDestinationDatabaseName(String destinationDatabaseName) {
            this.destinationDatabaseName = destinationDatabaseName;
        }

        @Override
        public final Builder destinationDatabaseName(String destinationDatabaseName) {
            this.destinationDatabaseName = destinationDatabaseName;
            return this;
        }

        public final Collection<String> getUniqueKeys() {
            if (this.uniqueKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.uniqueKeys;
        }

        public final void setUniqueKeys(Collection<String> uniqueKeys) {
            this.uniqueKeys = ListOfNonEmptyStringsWithoutWhitespaceCopier.copy(uniqueKeys);
        }

        @Override
        public final Builder uniqueKeys(Collection<String> uniqueKeys) {
            this.uniqueKeys = ListOfNonEmptyStringsWithoutWhitespaceCopier.copy(uniqueKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uniqueKeys(String ... uniqueKeys) {
            this.uniqueKeys(Arrays.asList(uniqueKeys));
            return this;
        }

        public final PartitionSpec.Builder getPartitionSpec() {
            return this.partitionSpec != null ? this.partitionSpec.toBuilder() : null;
        }

        public final void setPartitionSpec(PartitionSpec.BuilderImpl partitionSpec) {
            this.partitionSpec = partitionSpec != null ? partitionSpec.build() : null;
        }

        @Override
        public final Builder partitionSpec(PartitionSpec partitionSpec) {
            this.partitionSpec = partitionSpec;
            return this;
        }

        public final String getS3ErrorOutputPrefix() {
            return this.s3ErrorOutputPrefix;
        }

        public final void setS3ErrorOutputPrefix(String s3ErrorOutputPrefix) {
            this.s3ErrorOutputPrefix = s3ErrorOutputPrefix;
        }

        @Override
        public final Builder s3ErrorOutputPrefix(String s3ErrorOutputPrefix) {
            this.s3ErrorOutputPrefix = s3ErrorOutputPrefix;
            return this;
        }

        public DestinationTableConfiguration build() {
            return new DestinationTableConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationTableConfiguration> {
        public Builder destinationTableName(String var1);

        public Builder destinationDatabaseName(String var1);

        public Builder uniqueKeys(Collection<String> var1);

        public Builder uniqueKeys(String ... var1);

        public Builder partitionSpec(PartitionSpec var1);

        default public Builder partitionSpec(Consumer<PartitionSpec.Builder> partitionSpec) {
            return this.partitionSpec((PartitionSpec)((PartitionSpec.Builder)PartitionSpec.builder().applyMutation(partitionSpec)).build());
        }

        public Builder s3ErrorOutputPrefix(String var1);
    }
}

