/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.KxAzMode;
import software.amazon.awssdk.services.finspace.model.KxClusterStatus;
import software.amazon.awssdk.services.finspace.model.KxClusterType;
import software.amazon.awssdk.services.finspace.model.Volume;
import software.amazon.awssdk.services.finspace.model.VolumesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KxCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KxCluster> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(KxCluster.getter(KxCluster::statusAsString)).setter(KxCluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(KxCluster.getter(KxCluster::statusReason)).setter(KxCluster.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(KxCluster.getter(KxCluster::clusterName)).setter(KxCluster.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterType").getter(KxCluster.getter(KxCluster::clusterTypeAsString)).setter(KxCluster.setter(Builder::clusterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()}).build();
    private static final SdkField<String> CLUSTER_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterDescription").getter(KxCluster.getter(KxCluster::clusterDescription)).setter(KxCluster.setter(Builder::clusterDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterDescription").build()}).build();
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseLabel").getter(KxCluster.getter(KxCluster::releaseLabel)).setter(KxCluster.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()}).build();
    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumes").getter(KxCluster.getter(KxCluster::volumes)).setter(KxCluster.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Volume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INITIALIZATION_SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("initializationScript").getter(KxCluster.getter(KxCluster::initializationScript)).setter(KxCluster.setter(Builder::initializationScript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationScript").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(KxCluster.getter(KxCluster::executionRole)).setter(KxCluster.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final SdkField<String> AZ_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("azMode").getter(KxCluster.getter(KxCluster::azModeAsString)).setter(KxCluster.setter(Builder::azMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(KxCluster.getter(KxCluster::availabilityZoneId)).setter(KxCluster.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTimestamp").getter(KxCluster.getter(KxCluster::lastModifiedTimestamp)).setter(KxCluster.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTimestamp").getter(KxCluster.getter(KxCluster::createdTimestamp)).setter(KxCluster.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, STATUS_REASON_FIELD, CLUSTER_NAME_FIELD, CLUSTER_TYPE_FIELD, CLUSTER_DESCRIPTION_FIELD, RELEASE_LABEL_FIELD, VOLUMES_FIELD, INITIALIZATION_SCRIPT_FIELD, EXECUTION_ROLE_FIELD, AZ_MODE_FIELD, AVAILABILITY_ZONE_ID_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, CREATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("status", STATUS_FIELD);
            this.put("statusReason", STATUS_REASON_FIELD);
            this.put("clusterName", CLUSTER_NAME_FIELD);
            this.put("clusterType", CLUSTER_TYPE_FIELD);
            this.put("clusterDescription", CLUSTER_DESCRIPTION_FIELD);
            this.put("releaseLabel", RELEASE_LABEL_FIELD);
            this.put("volumes", VOLUMES_FIELD);
            this.put("initializationScript", INITIALIZATION_SCRIPT_FIELD);
            this.put("executionRole", EXECUTION_ROLE_FIELD);
            this.put("azMode", AZ_MODE_FIELD);
            this.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
            this.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
            this.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String statusReason;
    private final String clusterName;
    private final String clusterType;
    private final String clusterDescription;
    private final String releaseLabel;
    private final List<Volume> volumes;
    private final String initializationScript;
    private final String executionRole;
    private final String azMode;
    private final String availabilityZoneId;
    private final Instant lastModifiedTimestamp;
    private final Instant createdTimestamp;

    private KxCluster(BuilderImpl builder) {
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.clusterName = builder.clusterName;
        this.clusterType = builder.clusterType;
        this.clusterDescription = builder.clusterDescription;
        this.releaseLabel = builder.releaseLabel;
        this.volumes = builder.volumes;
        this.initializationScript = builder.initializationScript;
        this.executionRole = builder.executionRole;
        this.azMode = builder.azMode;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public final KxClusterStatus status() {
        return KxClusterStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final KxClusterType clusterType() {
        return KxClusterType.fromValue(this.clusterType);
    }

    public final String clusterTypeAsString() {
        return this.clusterType;
    }

    public final String clusterDescription() {
        return this.clusterDescription;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public final List<Volume> volumes() {
        return this.volumes;
    }

    public final String initializationScript() {
        return this.initializationScript;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final KxAzMode azMode() {
        return KxAzMode.fromValue(this.azMode);
    }

    public final String azModeAsString() {
        return this.azMode;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumes() ? this.volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationScript());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxCluster)) {
            return false;
        }
        KxCluster other = (KxCluster)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.clusterTypeAsString(), other.clusterTypeAsString()) && Objects.equals(this.clusterDescription(), other.clusterDescription()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && this.hasVolumes() == other.hasVolumes() && Objects.equals(this.volumes(), other.volumes()) && Objects.equals(this.initializationScript(), other.initializationScript()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.azModeAsString(), other.azModeAsString()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"KxCluster").add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("ClusterName", (Object)this.clusterName()).add("ClusterType", (Object)this.clusterTypeAsString()).add("ClusterDescription", (Object)this.clusterDescription()).add("ReleaseLabel", (Object)this.releaseLabel()).add("Volumes", this.hasVolumes() ? this.volumes() : null).add("InitializationScript", (Object)this.initializationScript()).add("ExecutionRole", (Object)this.executionRole()).add("AzMode", (Object)this.azModeAsString()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "clusterType": {
                return Optional.ofNullable(clazz.cast(this.clusterTypeAsString()));
            }
            case "clusterDescription": {
                return Optional.ofNullable(clazz.cast(this.clusterDescription()));
            }
            case "releaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "initializationScript": {
                return Optional.ofNullable(clazz.cast(this.initializationScript()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "azMode": {
                return Optional.ofNullable(clazz.cast(this.azModeAsString()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "lastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "createdTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KxCluster, T> g) {
        return obj -> g.apply((KxCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String statusReason;
        private String clusterName;
        private String clusterType;
        private String clusterDescription;
        private String releaseLabel;
        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();
        private String initializationScript;
        private String executionRole;
        private String azMode;
        private String availabilityZoneId;
        private Instant lastModifiedTimestamp;
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(KxCluster model) {
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.clusterName(model.clusterName);
            this.clusterType(model.clusterType);
            this.clusterDescription(model.clusterDescription);
            this.releaseLabel(model.releaseLabel);
            this.volumes(model.volumes);
            this.initializationScript(model.initializationScript);
            this.executionRole(model.executionRole);
            this.azMode(model.azMode);
            this.availabilityZoneId(model.availabilityZoneId);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxClusterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(KxClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final String getClusterDescription() {
            return this.clusterDescription;
        }

        public final void setClusterDescription(String clusterDescription) {
            this.clusterDescription = clusterDescription;
        }

        @Override
        public final Builder clusterDescription(String clusterDescription) {
            this.clusterDescription = clusterDescription;
            return this;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final List<Volume.Builder> getVolumes() {
            List<Volume.Builder> result = VolumesCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (Volume)((Volume.Builder)Volume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInitializationScript() {
            return this.initializationScript;
        }

        public final void setInitializationScript(String initializationScript) {
            this.initializationScript = initializationScript;
        }

        @Override
        public final Builder initializationScript(String initializationScript) {
            this.initializationScript = initializationScript;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getAzMode() {
            return this.azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public KxCluster build() {
            return new KxCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KxCluster> {
        public Builder status(String var1);

        public Builder status(KxClusterStatus var1);

        public Builder statusReason(String var1);

        public Builder clusterName(String var1);

        public Builder clusterType(String var1);

        public Builder clusterType(KxClusterType var1);

        public Builder clusterDescription(String var1);

        public Builder releaseLabel(String var1);

        public Builder volumes(Collection<Volume> var1);

        public Builder volumes(Volume ... var1);

        public Builder volumes(Consumer<Volume.Builder> ... var1);

        public Builder initializationScript(String var1);

        public Builder executionRole(String var1);

        public Builder azMode(String var1);

        public Builder azMode(KxAzMode var1);

        public Builder availabilityZoneId(String var1);

        public Builder lastModifiedTimestamp(Instant var1);

        public Builder createdTimestamp(Instant var1);
    }
}

