/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.finspace.model.AvailabilityZoneIdsCopier;
import software.amazon.awssdk.services.finspace.model.FinspaceRequest;
import software.amazon.awssdk.services.finspace.model.KxAzMode;
import software.amazon.awssdk.services.finspace.model.KxNAS1Configuration;
import software.amazon.awssdk.services.finspace.model.KxVolumeType;
import software.amazon.awssdk.services.finspace.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKxVolumeRequest
extends FinspaceRequest
implements ToCopyableBuilder<Builder, CreateKxVolumeRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateKxVolumeRequest.getter(CreateKxVolumeRequest::clientToken)).setter(CreateKxVolumeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(CreateKxVolumeRequest.getter(CreateKxVolumeRequest::environmentId)).setter(CreateKxVolumeRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeType").getter(CreateKxVolumeRequest.getter(CreateKxVolumeRequest::volumeTypeAsString)).setter(CreateKxVolumeRequest.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeType").build()}).build();
    private static final SdkField<String> VOLUME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeName").getter(CreateKxVolumeRequest.getter(CreateKxVolumeRequest::volumeName)).setter(CreateKxVolumeRequest.setter(Builder::volumeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateKxVolumeRequest.getter(CreateKxVolumeRequest::description)).setter(CreateKxVolumeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<KxNAS1Configuration> NAS1_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nas1Configuration").getter(CreateKxVolumeRequest.getter(CreateKxVolumeRequest::nas1Configuration)).setter(CreateKxVolumeRequest.setter(Builder::nas1Configuration)).constructor(KxNAS1Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nas1Configuration").build()}).build();
    private static final SdkField<String> AZ_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("azMode").getter(CreateKxVolumeRequest.getter(CreateKxVolumeRequest::azModeAsString)).setter(CreateKxVolumeRequest.setter(Builder::azMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("availabilityZoneIds").getter(CreateKxVolumeRequest.getter(CreateKxVolumeRequest::availabilityZoneIds)).setter(CreateKxVolumeRequest.setter(Builder::availabilityZoneIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateKxVolumeRequest.getter(CreateKxVolumeRequest::tags)).setter(CreateKxVolumeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ENVIRONMENT_ID_FIELD, VOLUME_TYPE_FIELD, VOLUME_NAME_FIELD, DESCRIPTION_FIELD, NAS1_CONFIGURATION_FIELD, AZ_MODE_FIELD, AVAILABILITY_ZONE_IDS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("environmentId", ENVIRONMENT_ID_FIELD);
            this.put("volumeType", VOLUME_TYPE_FIELD);
            this.put("volumeName", VOLUME_NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("nas1Configuration", NAS1_CONFIGURATION_FIELD);
            this.put("azMode", AZ_MODE_FIELD);
            this.put("availabilityZoneIds", AVAILABILITY_ZONE_IDS_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String clientToken;
    private final String environmentId;
    private final String volumeType;
    private final String volumeName;
    private final String description;
    private final KxNAS1Configuration nas1Configuration;
    private final String azMode;
    private final List<String> availabilityZoneIds;
    private final Map<String, String> tags;

    private CreateKxVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.environmentId = builder.environmentId;
        this.volumeType = builder.volumeType;
        this.volumeName = builder.volumeName;
        this.description = builder.description;
        this.nas1Configuration = builder.nas1Configuration;
        this.azMode = builder.azMode;
        this.availabilityZoneIds = builder.availabilityZoneIds;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final KxVolumeType volumeType() {
        return KxVolumeType.fromValue(this.volumeType);
    }

    public final String volumeTypeAsString() {
        return this.volumeType;
    }

    public final String volumeName() {
        return this.volumeName;
    }

    public final String description() {
        return this.description;
    }

    public final KxNAS1Configuration nas1Configuration() {
        return this.nas1Configuration;
    }

    public final KxAzMode azMode() {
        return KxAzMode.fromValue(this.azMode);
    }

    public final String azModeAsString() {
        return this.azMode;
    }

    public final boolean hasAvailabilityZoneIds() {
        return this.availabilityZoneIds != null && !(this.availabilityZoneIds instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZoneIds() {
        return this.availabilityZoneIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.nas1Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZoneIds() ? this.availabilityZoneIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxVolumeRequest)) {
            return false;
        }
        CreateKxVolumeRequest other = (CreateKxVolumeRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.volumeTypeAsString(), other.volumeTypeAsString()) && Objects.equals(this.volumeName(), other.volumeName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.nas1Configuration(), other.nas1Configuration()) && Objects.equals(this.azModeAsString(), other.azModeAsString()) && this.hasAvailabilityZoneIds() == other.hasAvailabilityZoneIds() && Objects.equals(this.availabilityZoneIds(), other.availabilityZoneIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKxVolumeRequest").add("ClientToken", (Object)this.clientToken()).add("EnvironmentId", (Object)this.environmentId()).add("VolumeType", (Object)this.volumeTypeAsString()).add("VolumeName", (Object)this.volumeName()).add("Description", (Object)this.description()).add("Nas1Configuration", (Object)this.nas1Configuration()).add("AzMode", (Object)this.azModeAsString()).add("AvailabilityZoneIds", this.hasAvailabilityZoneIds() ? this.availabilityZoneIds() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "volumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeTypeAsString()));
            }
            case "volumeName": {
                return Optional.ofNullable(clazz.cast(this.volumeName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "nas1Configuration": {
                return Optional.ofNullable(clazz.cast(this.nas1Configuration()));
            }
            case "azMode": {
                return Optional.ofNullable(clazz.cast(this.azModeAsString()));
            }
            case "availabilityZoneIds": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneIds()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateKxVolumeRequest, T> g) {
        return obj -> g.apply((CreateKxVolumeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String environmentId;
        private String volumeType;
        private String volumeName;
        private String description;
        private KxNAS1Configuration nas1Configuration;
        private String azMode;
        private List<String> availabilityZoneIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKxVolumeRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.environmentId(model.environmentId);
            this.volumeType(model.volumeType);
            this.volumeName(model.volumeName);
            this.description(model.description);
            this.nas1Configuration(model.nas1Configuration);
            this.azMode(model.azMode);
            this.availabilityZoneIds(model.availabilityZoneIds);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(KxVolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final String getVolumeName() {
            return this.volumeName;
        }

        public final void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @Override
        public final Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final KxNAS1Configuration.Builder getNas1Configuration() {
            return this.nas1Configuration != null ? this.nas1Configuration.toBuilder() : null;
        }

        public final void setNas1Configuration(KxNAS1Configuration.BuilderImpl nas1Configuration) {
            this.nas1Configuration = nas1Configuration != null ? nas1Configuration.build() : null;
        }

        @Override
        public final Builder nas1Configuration(KxNAS1Configuration nas1Configuration) {
            this.nas1Configuration = nas1Configuration;
            return this;
        }

        public final String getAzMode() {
            return this.azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final Collection<String> getAvailabilityZoneIds() {
            if (this.availabilityZoneIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZoneIds;
        }

        public final void setAvailabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsCopier.copy(availabilityZoneIds);
        }

        @Override
        public final Builder availabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsCopier.copy(availabilityZoneIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneIds(String ... availabilityZoneIds) {
            this.availabilityZoneIds(Arrays.asList(availabilityZoneIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKxVolumeRequest build() {
            return new CreateKxVolumeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKxVolumeRequest> {
        public Builder clientToken(String var1);

        public Builder environmentId(String var1);

        public Builder volumeType(String var1);

        public Builder volumeType(KxVolumeType var1);

        public Builder volumeName(String var1);

        public Builder description(String var1);

        public Builder nas1Configuration(KxNAS1Configuration var1);

        default public Builder nas1Configuration(Consumer<KxNAS1Configuration.Builder> nas1Configuration) {
            return this.nas1Configuration((KxNAS1Configuration)((KxNAS1Configuration.Builder)KxNAS1Configuration.builder().applyMutation(nas1Configuration)).build());
        }

        public Builder azMode(String var1);

        public Builder azMode(KxAzMode var1);

        public Builder availabilityZoneIds(Collection<String> var1);

        public Builder availabilityZoneIds(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

